% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{getBranchQual}
\alias{getBranchQual}
\title{Descendant branch calculations for quantitative variable}
\usage{
getBranchQual(v1, geneal, colName, rExpr, gen = 3)
}
\arguments{
\item{v1}{the label of the vertex of interest (in character string format)}

\item{geneal}{the full genealogy  (in data frame format)}

\item{colName}{the name of the column of the data frame that contains the qualitative variable of interest (in character string format)}

\item{rExpr}{regular expression to be applied to the column that contains the qualitative variable of interest (in character string format). The regular expression syntax must work on a data frame column of type character. The term geneal$colName must be used in the regular expression.}

\item{gen}{the number of generations back to include as ancestors}
}
\description{
Returns a data frame containing the names of all children of an individual of interest ("Name"). The mean and standard deviation ("Mean" and "SD") of a quantitative variable across all descendents of each child is reported. In addition, for each child, the number of its descendants is reported ("Count"), the number of its descendants who do not have a value for the quantitative variable ("NACount") is reported, and the names of all of its descendants is reported ("DesNames").
}
\examples{
data(statGeneal)
rExpr = "geneal$colName=='The Johns Hopkins University'"
DC_JHU = getBranchQual("David Cox", statGeneal, "school", rExpr, 15)
rExpr = "geneal$colName=='UnitedKingdom'"
DC_UK = getBranchQual("David Cox", statGeneal, "country", rExpr, 15)
rExpr = "grepl('(?i)Stochastic', geneal$colName)"
DC_Stochastic = getBranchQual("David Cox", statGeneal, "thesis", rExpr, 15)
}
\references{
Rutter L, VanderPlas S, Cook D, Graham MA (2019).
ggenealogy: An R Package for Visualizing Genealogical Data.
\emph{Journal of Statistical Software},
\bold{89}(13), 1--31.
\doi{10.18637/jss.v089.i13}
}
