% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spiro.R
\name{geom_spiro}
\alias{geom_spiro}
\alias{stat_spiro}
\title{Draw spirograms based on the radii of the different "wheels" involved}
\usage{
stat_spiro(mapping = NULL, data = NULL, geom = "path",
  position = "identity", na.rm = FALSE, n = 500,
  revolutions = NULL, show.legend = NA, inherit.aes = TRUE, ...)

geom_spiro(mapping = NULL, data = NULL, stat = "spiro",
  position = "identity", arrow = NULL, n = 500, lineend = "butt",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{n}{The number of points that should be used to draw a fully closed
spirogram. If \code{revolutions < 1} the actual number of points will be less
than this.}

\item{revolutions}{The number of times the inner gear should revolve around
inside the outer gear. If \code{NULL} the number of revolutions to reach the
starting position is calculated and used.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{arrow}{Arrow specification, as created by \code{\link[grid:arrow]{grid::arrow()}}.}

\item{lineend}{Line end style (round, butt, square).}
}
\description{
This, rather pointless, geom allows you to draw spirograms, as known from the
popular drawing toy where lines were traced by inserting a pencil into a hole
in a small gear that would then trace around inside another gear. The
potential practicality of this geom is slim and it excists mainly for fun and
art.
}
\section{Aesthetics}{

stat_spiro and geom_spiro understand the following aesthetics (required
aesthetics are in bold):
\itemize{
\item \strong{R}
\item \strong{r}
\item \strong{d}
\item x0
\item y0
\item outer
\item color
\item size
\item linetype
\item alpha
}
}

\section{Computed variables}{


\describe{
\item{x, y}{The coordinates for the path describing the spirogram}
\item{index}{The progression along the spirogram mapped between 0 and 1}
}
}

\examples{
# Basic usage
ggplot() +
  geom_spiro(aes(R = 10, r = 3, d = 5))

# Only draw a portion
ggplot() +
  geom_spiro(aes(R = 10, r = 3, d = 5), revolutions = 1.2)

# Let the inner gear circle the outside of the outer gear
ggplot() +
  geom_spiro(aes(R = 10, r = 3, d = 5, outer = TRUE))
}
