% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_boxplot}
\alias{gf_boxplot}
\title{Formula interface to geom_boxplot()}
\usage{
gf_boxplot(object = NULL, gformula = NULL, data = NULL, geom = type,
  verbose = FALSE, add = inherits(object, c("gg", "ggplot")), ...,
  position = NULL, show.help = NULL)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{y ~ x}.
Faceting can be acheived by including \code{|} in the formula.}

\item{data}{A data frame with the variables to be plotted.}

\item{geom}{A way to specify ggplot geoms that are not aliased to gf functions.}

\item{verbose}{If \code{TRUE} print the ggplot2 command in the console.}

\item{add}{If \code{TRUE} then construct just the layer with no frame.  The result
can be added to an existing frame.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.
Available attributes include
\code{alpha}, \code{color}, \code{fill}, \code{group}, \code{linetype}, \code{shape}, \code{size}, \code{weight}, \code{coef}, \code{outlier.color}, \code{outlier.fill}, \code{outlier.shape}, \code{outlier.size}, \code{outlier.stroke}, \code{outlier.alpha}, \code{notch}, \code{notchwidth}, \code{varwidth}}

\item{position}{Position adjustment, either as a string, or the result of a call to a position adjustment function.}

\item{show.help}{If \code{TRUE}, display some minimal help.}
}
\value{
a gg object
Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}
\description{
\pkg{ggformula} functions provide a formula interface to \code{ggplot2} layer
functions.
For plots with just one layer, the formula interface
is more compact and is consistent with modeling and \pkg{mosaic} notation.
The functions generate a \code{ggplot} command string which can be displayed by
setting \code{verbose = TRUE} as an argument.
}
\details{
Positional aesthetics are typically specified using a formula (see the \code{gformula} argument).
Additional formula terms of the form \code{+ attribute::value} map \code{attribute}
to \code{value}.
Additional terms of the form \code{+ attribute:value} will map \code{attribute}
to \code{value} if \code{value} is the name of a variable in \code{data}, else
\code{attribute} will be set to the constant \code{value}. Alternatively (and preferably)
attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.
In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link{facet_wrap}()} or \code{\link{facet_grid}()}.
This provides an alternative to
\code{\link{gf_facet_wrap}()} and
\code{\link{gf_facet_grid}()} that is terser and may feel more familiar to users
of \pkg{lattice}.
}
\examples{
if (require(mosaicData)) {
  gf_boxplot(age ~ substance, data = HELPrct)
  gf_boxplot(age ~ substance, data = HELPrct, varwidth = TRUE)
  gf_boxplot(age ~ substance, data = HELPrct, color = ~sex)
  gf_boxplot(age ~ substance, data = HELPrct, color = ~sex, outlier.color = "gray50")
  # longer whiskers
  gf_boxplot(age ~ substance, data = HELPrct, color = ~sex, coef = 2)
  gf_boxplot(age ~ substance, data = HELPrct, color = ~sex, position = position_dodge(width = 0.9))
}
}
\seealso{
\code{\link{geom_boxplot}()}
}
