% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newplots.R
\name{stat_lm}
\alias{stat_lm}
\alias{geom_lm}
\title{Linear Model Displays}
\usage{
stat_lm(mapping = NULL, data = NULL, geom = "lm", position = "identity",
  interval = c("none", "prediction", "confidence"), level = 0.95,
  formula = y ~ x, lm.args = list(), backtrans = identity, ...,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)

geom_lm(mapping = NULL, data = NULL, stat = "lm", position = "identity",
  interval = c("none", "prediction", "confidence"), level = 0.95,
  formula = y ~ x, lm.args = list(), backtrans = identity, ...,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{geom, stat}{Use to override the default connection between
\code{geom_lm} and \code{stat_lm}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{interval}{One of \code{"none"}, \code{"confidence"} or \code{"prediction"}.}

\item{level}{The level used for confidence or prediction intervals}

\item{formula}{a formula describing the model in terms of \code{y} (response)
and \code{x} (predictor).}

\item{lm.args}{A list of arguments supplied to \code{\link[=lm]{lm()}} when performing the fit.}

\item{backtrans}{a function that transforms the response back to
the original scale when the \code{formula} includes a transformation on
\code{y}.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}
}
\description{
Adds linear model fits to plots. \code{geom_lm()} and \code{stat_lm()} are essentially
equivalent.  Use \code{geom_lm()} unless you want a non-standard geom.
}
\details{
Stat calculation is performed by the (currently undocumented)
\code{predictdf}.  Pointwise confidence or prediction bands are
calculated using the \code{\link[=predict]{predict()}} method.
}
\examples{
if (require(mosaicData)) {
  ggplot(data = KidsFeet, aes(y = length, x = width, color = sex)) +
    geom_lm() +
    geom_point()
  ggplot(data = KidsFeet, aes(y = length, x = width, color = sex)) +
    geom_lm(interval = "prediction", color = "skyblue") +
    geom_lm(interval = "confidence") +
    geom_point() +
    facet_wrap(~sex)
 # non-standard display
  ggplot(data = KidsFeet, aes(y = length, x = width, color = sex)) +
    stat_lm(aes(fill = sex), color = NA, interval = "confidence", geom = "ribbon",
    alpha = 0.2) +
    geom_point() +
    facet_wrap(~sex)
ggplot(mpg, aes(displ, hwy)) +
   geom_lm(formula = log(y) ~ poly(x,3), backtrans = exp,
     interval = "prediction", fill = "skyblue") +
   geom_lm(formula = log(y) ~ poly(x,3), backtrans = exp, interval = "confidence",
     color = "red") +
   geom_point()
}
}
\seealso{
\code{\link[=lm]{lm()}} for details on linear model fitting.
}
