% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_density}
\alias{gf_density}
\alias{gf_dens}
\title{Formula interface to stat_density()}
\usage{
gf_density(object = NULL, gformula = NULL, data = NULL,
  alpha = 0.5, color, fill, group, linetype, size, kernel = "gaussian",
  n = 512, trim = FALSE, xlab, ylab, title, subtitle, caption,
  geom = "area", stat = "density", position = "identity",
  show.legend = NA, show.help = NULL, inherit = TRUE,
  environment = parent.frame(), ...)

gf_dens(object = NULL, gformula = NULL, data = NULL, alpha = 0.5,
  color, group, linetype, size, kernel = "gaussian", n = 512,
  trim = FALSE, xlab, ylab, title, subtitle, caption, geom = "line",
  stat = "density", position = "identity", show.legend = NA,
  show.help = NULL, inherit = TRUE, environment = parent.frame(),
  ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{color}{A color or a formula used for mapping color.}

\item{fill}{A color for filling, or a formula used for mapping fill.}

\item{group}{Used for grouping.}

\item{linetype}{A linetype (numeric or "dashed", "dotted", etc.) or a formula used
for mapping linetype.}

\item{size}{A numeric size or a formula used for mapping size.}

\item{kernel}{Kernel. See list of available kernels in \code{\link[=density]{density()}}.}

\item{n}{number of equally spaced points at which the density is to be
estimated, should be a power of two, see \code{\link[=density]{density()}} for
details}

\item{trim}{This parameter only matters if you are displaying multiple
densities in one plot. If \code{FALSE}, the default, each density is
computed on the full range of the data. If \code{TRUE}, each density
is computed over the range of that group: this typically means the
estimated x values will not line-up, and hence you won't be able to
stack density values.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{geom}{Use to override the default connection between
\code{geom_density} and \code{stat_density}.}

\item{stat}{Use to override the default connection between
\code{geom_density} and \code{stat_density}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~ expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}
}
\value{
a gg object
}
\description{
Computes and draws a kernel density estimate, which is a smoothed version of the
histogram and is a useful alternative when the data come from an underlying smooth
distribution.
The only difference between \code{gf_dens()} and \code{gf_density()} is the default geom
used to show the density curve: \code{gf_density()} uses an area geom (which can be filled).
\code{gf_dens()} using a line geom (which cannot be filled).
}
\section{Specifying plot attributes}{


Positional attributes (a.k.a, aesthetics) are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.
}

\section{Evaluation}{


Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}

\examples{
gf_dens()
gf_density( ~ Sepal.Length,  fill = ~ Species, data = iris)
gf_dens( ~ Sepal.Length, color = ~ Species, data = iris)
gf_freqpoly( ~ Sepal.Length, color = ~ Species, data = iris, bins = 15)
# Chaining in the data
iris \%>\% gf_dens( ~ Sepal.Length, color = ~ Species)
}
\seealso{
\code{\link[=gf_ash]{gf_ash()}}, \code{\link[ggplot2:geom_density]{ggplot2::geom_density()}}
}
