% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_dotplot}
\alias{gf_dotplot}
\title{Formula interface to geom_dotplot()}
\usage{
gf_dotplot(
  object = NULL,
  gformula = NULL,
  data = NULL,
  ...,
  alpha,
  color,
  fill,
  group,
  binwidth = NULL,
  binaxis = "x",
  method = "dotdensity",
  binpositions = "bygroup",
  stackdir = "up",
  stackratio = 1,
  dotsize = 1,
  stackgroups = FALSE,
  origin = NULL,
  right = TRUE,
  width = 0.9,
  drop = FALSE,
  xlab,
  ylab,
  title,
  subtitle,
  caption,
  position = "identity",
  show.legend = NA,
  show.help = NULL,
  inherit = TRUE,
  environment = parent.frame()
)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{A data frame with the variables to be plotted.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~ expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{color}{A color or a formula used for mapping color.}

\item{fill}{A color for filling, or a formula used for mapping fill.}

\item{group}{Used for grouping.}

\item{binwidth}{When \code{method} is "dotdensity", this specifies maximum bin
width. When \code{method} is "histodot", this specifies bin width.
Defaults to 1/30 of the range of the data}

\item{binaxis}{The axis to bin along, "x" (default) or "y"}

\item{method}{"dotdensity" (default) for dot-density binning, or
"histodot" for fixed bin widths (like stat_bin)}

\item{binpositions}{When \code{method} is "dotdensity", "bygroup" (default)
determines positions of the bins for each group separately. "all" determines
positions of the bins with all the data taken together; this is used for
aligning dot stacks across multiple groups.}

\item{stackdir}{which direction to stack the dots. "up" (default),
"down", "center", "centerwhole" (centered, but with dots aligned)}

\item{stackratio}{how close to stack the dots. Default is 1, where dots just
just touch. Use smaller values for closer, overlapping dots.}

\item{dotsize}{The diameter of the dots relative to \code{binwidth}, default 1.}

\item{stackgroups}{should dots be stacked across groups? This has the effect
that \code{position = "stack"} should have, but can't (because this geom has
some odd properties).}

\item{origin}{When \code{method} is "histodot", origin of first bin}

\item{right}{When \code{method} is "histodot", should intervals be closed
on the right (a, b], or not [a, b)}

\item{width}{When \code{binaxis} is "y", the spacing of the dot stacks
for dodging.}

\item{drop}{If TRUE, remove all bins with zero counts}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{show.legend}{A logical indicating whether this layer should be included in
the legends.  \code{NA}, the default, includes layer in the legends if any
of the attributes of the layer are mapped.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}
}
\value{
a gg object
}
\description{
Scatterplots in \code{ggformula}.
}
\details{
There are two basic approaches: \emph{dot-density} and \emph{histodot}.
With dot-density binning, the bin positions are determined by the data and
\code{binwidth}, which is the maximum width of each bin. See Wilkinson
(1999) for details on the dot-density binning algorithm. With histodot
binning, the bins have fixed positions and fixed widths, much like a
histogram.

When binning along the x axis and stacking along the y axis, the numbers on
y axis are not meaningful, due to technical limitations of ggplot2. You can
hide the y axis, as in one of the examples, or manually scale it
to match the number of dots.
}
\section{Warning}{

Dotplots in \code{ggplot2} (and hence in \code{ggformula}) often require some fiddling because
the default y-axis is meaningless and the ideal size of the dots depends on the
aspect ratio of the plot.
}

\section{Specifying plot attributes}{


Positional attributes (a.k.a, aesthetics) are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.
}

\section{Evaluation}{


Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}

\examples{
gf_dotplot(~Sepal.Length, fill = ~Species, data = iris)
}
\references{
Wilkinson, L. (1999) Dot plots. The American Statistician,
53(3), 276-281.
}
\seealso{
\code{\link[ggplot2:geom_dotplot]{ggplot2::geom_dotplot()}}
}
