% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_stats.R
\name{autoplot.stepfun}
\alias{autoplot.stepfun}
\title{Plot \code{stats::stepfun}}
\usage{
\method{autoplot}{stepfun}(object, colour = NULL, size = NULL,
  linetype = NULL, alpha = NULL, shape = 1, xlim = c(NA, NA),
  ylim = c(NA, NA), log = "", main = NULL, xlab = NULL, ylab = NULL,
  asp = NULL, ...)
}
\arguments{
\item{object}{\code{stats::stepfun} instance}

\item{colour}{colour}

\item{size}{point size}

\item{linetype}{line type}

\item{alpha}{alpha}

\item{shape}{point shape}

\item{xlim}{limits for x axis}

\item{ylim}{limits for y axis}

\item{log}{which variables to log transform ("x", "y", or "xy")}

\item{main}{character vector or expression for plot title}

\item{xlab}{character vector or expression for x axis label}

\item{ylab}{character vector or expression for y axis label}

\item{asp}{the y/x aspect ratio}

\item{...}{other arguments passed to methods}
}
\value{
ggplot
}
\description{
Plot \code{stats::stepfun}
}
\examples{
autoplot(stepfun(c(1, 2, 3), c(4, 5, 6, 7)))
autoplot(stepfun(c(1), c(4, 5)), shape = NULL)
autoplot(stepfun(c(1, 3, 4, 8), c(4, 5, 2, 3, 5)), linetype = 'dashed')
autoplot(stepfun(c(1, 2, 3, 4, 5, 6, 7, 8, 10), c(4, 5, 6, 7, 8, 9, 10, 11, 12, 9)), colour = 'red')
}

