% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_segment_c.R
\name{geom_segment_c}
\alias{geom_segment_c}
\title{geom_segment_c}
\usage{
geom_segment_c(
  mapping = NULL,
  data = NULL,
  position = "identity",
  lineend = "butt",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  arrow = NULL,
  arrow.fill = NULL,
  ...
)
}
\arguments{
\item{mapping}{aes mapping}

\item{data}{data}

\item{position}{position}

\item{lineend}{lineend}

\item{na.rm}{logical}

\item{show.legend}{logical}

\item{inherit.aes}{logical}

\item{arrow}{specification for arrow heads, as created by arrow().}

\item{arrow.fill}{fill color to usse for the arrow head (if closed). \code{NULL} means use \code{colour} aesthetic.}

\item{...}{additional parameter}
}
\value{
add segment layer
}
\description{
geom_segment_c supports coloring segment with continuous colors
}
\examples{
set.seed(2019-06-28)
d = data.frame(x = rnorm(10),
              xend = rnorm(10),
              y = rnorm(10),
              yend = rnorm(10),
              v1 = rnorm(10),
              v2 = rnorm(10))
library(ggplot2)
ggplot(d) + geom_segment_c(aes(x = x, xend = xend, y=y, yend =yend, col0 = v1, col1 = v2)) +
   scale_color_viridis_c(name = "continuous colored lines") + 
   theme_minimal() + theme(legend.position=c(.2, .85)) + xlab(NULL) + ylab(NULL)
}
\seealso{
\link[ggplot2]{geom_segment}
}
\author{
Guangchuang Yu
}
