% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guitar_chords.R
\name{tablature}
\alias{tablature}
\title{Create guitar chord tablature chart.}
\usage{
tablature(name, desc, include_text = TRUE, include_title = TRUE,
  x_labels = NULL, x_axis_label = "String", dot_labels = NULL,
  dot_label_size = 2)
}
\arguments{
\item{name}{The name of the chord}

\item{desc}{A vector with 6 elements representing strings.
A number indicates the fret and NA indicates a string
should not be played.}

\item{include_text}{Include tick mark labels on x and y axis.  Default is TRUE.}

\item{include_title}{Include the labels on the x and y axis. Default is TRUE.}

\item{x_labels}{A vector containing x tick mark labels.  Default is string numbers.}

\item{x_axis_label}{The x axis label.  Default is String.}

\item{dot_labels}{Adds labels in place of dots on frets.}

\item{dot_label_size}{Set the size of labels used in place of dots on frets.}
}
\description{
Create guitar chord tablature chart.
}
\examples{
tablature('G Major', c(3, 2, 0, 0, 0, 3))

B_M <- c(NA, 2, 4, 4, 4, 2)
tablature('B Major (bar)', B_M,
           x_labels=c(0,1,3,3,3,1),
           x_axis_label = 'Finger')

tablature('B Major (bar)', B_M,
           dot_labels = c('','B','F#','B','D#','F#'))
}

