% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_axis_truncated.R
\name{guide_axis_truncated}
\alias{guide_axis_truncated}
\alias{guide_axis_colour}
\alias{guide_axis_color}
\title{Axis guide with truncated line}
\usage{
guide_axis_truncated(
  title = waiver(),
  check.overlap = FALSE,
  angle = NULL,
  n.dodge = 1,
  order = 0,
  colour = NULL,
  color = NULL,
  trunc_lower = min,
  trunc_upper = max,
  position = waiver()
)

guide_axis_colour(
  title = waiver(),
  check.overlap = FALSE,
  angle = NULL,
  n.dodge = 1,
  order = 0,
  colour = NULL,
  color = NULL,
  trunc_lower = NULL,
  trunc_upper = NULL,
  position = waiver()
)

guide_axis_color(
  title = waiver(),
  check.overlap = FALSE,
  angle = NULL,
  n.dodge = 1,
  order = 0,
  colour = NULL,
  color = NULL,
  trunc_lower = NULL,
  trunc_upper = NULL,
  position = waiver()
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{check.overlap}{silently remove overlapping labels,
(recursively) prioritizing the first, last, and middle labels.}

\item{angle}{Compared to setting the angle in \code{\link[ggplot2:theme]{theme()}} / \code{\link[ggplot2:element_text]{element_text()}},
this also uses some heuristics to automatically pick the \code{hjust} and \code{vjust} that
you probably want.}

\item{n.dodge}{The number of rows (for vertical axes) or columns (for
horizontal axes) that should be used to render the labels. This is
useful for displaying labels that would otherwise overlap.}

\item{order}{Used to determine the order of the guides (left-to-right,
top-to-bottom), if more than one  guide must be drawn at the same location.}

\item{colour, color}{A \code{character(1)} with a valid colour for colouring the
axis text, axis ticks and axis line. Overrules the colour assigned by the
theme.}

\item{trunc_lower, trunc_upper}{The lower and upper range of the truncated
axis:
\itemize{
\item \code{NULL} to not perform any truncation.
\item A \code{function} that takes the break positions as input and returns the lower
or upper boundary. Note that also for discrete scales, positions are the
mapped positions as \code{numeric}.
\item A \code{numeric} value in data units for the lower and upper boundaries.
\item A \code{unit} object.
}}

\item{position}{Where this guide should be drawn: one of top, bottom,
left, or right.}
}
\value{
An \emph{axis_ggh4x} guide class object.
}
\description{
This axis guide is similar to the normal axis guides for position scales, but
can shorten the axis line that is being drawn. The \code{guide_axis_colour()}
function is the same but with different defaults for the truncation that do
not truncate the axis. Axis truncation and recolouring is supported
throughout axes in ggh4x.
}
\examples{
# Make a plot
p <- ggplot(mtcars, aes(wt, mpg)) +
  geom_point() +
  theme(axis.line = element_line(colour = "black"))

# Setting the default truncated axis
p + guides(x = "axis_truncated")

# Truncating in data units
p + guides(x = guide_axis_truncated(
  trunc_lower = 2.5, trunc_upper = 4.5
))

# Truncate by setting units
p + guides(x = guide_axis_truncated(
  trunc_lower = unit(0.1, "npc"),
  trunc_upper = unit(0.9, "npc")
))

# Truncating with functions
p + guides(x = guide_axis_truncated(
  trunc_lower = function(x) {x - 0.2},
  trunc_upper = function(x) {x + 0.2}
))

# Recolouring the axes outside the theme
p + guides(x = guide_axis_colour(colour = "red"),
           y = guide_axis_colour(colour = "blue"))
}
\seealso{
Other axis-guides: 
\code{\link{guide_axis_logticks}()},
\code{\link{guide_axis_manual}()},
\code{\link{guide_axis_minor}()},
\code{\link{guide_axis_nested}()},
\code{\link{guide_axis_scalebar}()}
}
\concept{axis-guides}
