% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_manual.R
\name{sep_discrete}
\alias{sep_discrete}
\title{Separator for discrete grouped labels}
\usage{
sep_discrete(sep = ".", inv = FALSE)
}
\arguments{
\item{sep}{A \code{character(1)} separator to use for splitting. May not contain
regular expressions.}

\item{inv}{A \code{logical(1)} whether to invert the layering of groups.}
}
\value{
A \code{function} that accepts \code{character} input and returns
\code{numeric} output.
}
\description{
This is a function factory that provides a function to split grouped discrete
labels into numerical positions.
}
\examples{
# Here, 'bar.qux' belongs to the second group, so has +1 value
sep_discrete()(c("foo.bar", "bar.bar", "bar.qux"))

# Now, the values are grouped by the groups before the separator
sep_discrete(inv = TRUE)(c("foo.bar", "bar.bar", "bar.qux"))
}
