% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bats}
\alias{bats}
\title{Observations from a bat detector}
\format{
A \code{data.frame} with 1,049 rows and 2 columns:
\itemize{
\item \code{RECDATETIME}: datetime of the recorded bat call sequence
\item \code{SPECDESCSCI}: scientific species name
}

It also contains an attribute named \code{monitoring} which is a \code{data.frame}
containing monitoring periods at which the bat detector was active. Each
row is a monitoring period, and it holds the following columns:
\itemize{
\item \code{start}: start datetime of the monitoring period
\item \code{end}: end datetime of the monitoring period
\item \code{time_on}: time of day at which the detector is activated
during the monitoring period
\item \code{time_off}: time of day at which the detector is deactivated
during the monitoring period
\item \code{longitude} and \code{latitude}: coordinates of the detector's location
\item \code{altitude}: altitude in meters above sea level of the detector.
}
}
\description{
A dataset containing detections of audio call sequences from
bats. It is a small subset of the data published by Lagerveld et al. (2023)
}
\examples{
data("bats")
}
\references{
Lagerveld, S., Wilkes, T., van Puijenbroek, M.E.B., Noort, B.C.A., Geelhoed,
S.C.V. Acoustic monitoring reveals spatiotemporal occurrence of Nathusius’ pipistrelle
at the southern North Sea during autumn migration. Environ Monit Assess 195, 1016 (2023)
\url{doi:10.1007/s10661-023-11590-2}
}
