% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lunar-calcs.R
\docType{data}
\name{AnnotateLunarphase}
\alias{AnnotateLunarphase}
\alias{annotate_lunarphase}
\title{Annotate ggplot with lunar phases}
\format{
An object of class \code{AnnotateLunarphase} (inherits from \code{GeomPolygon}, \code{Geom}, \code{ggproto}, \code{gg}) of length 6.
}
\usage{
AnnotateLunarphase

annotate_lunarphase(
  date = NULL,
  longitude = NULL,
  latitude = NULL,
  breaks = ggplot2::waiver(),
  placement = 0.9,
  radius = grid::unit(5, "mm"),
  n = 26,
  ...
)
}
\arguments{
\item{date}{A datetime object used to calculate the illuminated fraction of the moon}

\item{longitude, latitude}{Used to calculate zenith angle. This will result in a more accurate
shape of the moon as observed at the specified location.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the breaks specified by \code{date_breaks}
\item A \code{Date}/\code{POSIXct} vector giving positions of breaks
\item A function that takes the limits as input and returns breaks as output
}}

\item{placement}{Relative placement of the lunar annotation in the plotting
panel. It should be between 0 and 1. Default is 0.9.}

\item{radius}{Size of the lunar pictogram. It is best to use an absolute
unit from the \code{grid} package. Default is a radius of 5 mm (\code{grid::unit(5, "mm")})}

\item{n}{Number of coordinates in the returned polygon shape (should be even).}

\item{...}{Passed to the list of layer parameters.}
}
\value{
Returns a \code{\link[ggplot2:layer]{ggplot2::layer()}} which can be added to a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
\description{
This function uses the \code{suncalc} package to calculate the lunar phase
and uses it to annotate your plot. If your plot has an axis with a
continuous datetime scale, lunar phases are plot along this axis.
Otherwise you have to specify the date of the lunar phase.
}
\examples{
library(ggplot2)
library(dplyr)
library(lubridate)
data(bats)

monitoring <- attr(bats, "monitoring")

## A lunar annotation can be added to a geom_hourglass layer
ggplot(mutate(bats, YEAR = year(RECDATETIME), MONTH = month(RECDATETIME)) |>
         filter(YEAR == 2018, MONTH == 5),
       aes(x = RECDATETIME, col = SPECDESCSCI)) +
  
  geom_hourglass() +
  
  annotate_lunarphase(
    longitude = monitoring$longitude[[1]],
    latitude  = monitoring$latitude[[1]],
    placement = 0.8) +
  
  scale_x_datetime(limits = as_datetime(c("2018-04-27", "2018-05-31")))

## In fact, it can be added to any plot with a continuous datetime scale

ggplot(data.frame(stamp = seq(as_datetime("2025-04-01 UTC"),
                              as_datetime("2025-04-30 UTC"),
                              length.out = 20),
                  value = 1:20), aes(x = stamp, y = value)) +
  geom_point() +
  annotate_lunarphase()

## Moreover, you can add it to an arbitrary plot without such scales,
## but then you need to specify the date

ggplot(data.frame(stamp = 1:20,
                  value = 1:20), aes(x = stamp, y = value)) +
  geom_point() +
  annotate_lunarphase(date = "2020-01-01", placement = c(0.1, 0.9))
}
\author{
Pepijn de Vries
}
\keyword{datasets}
