% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_bar_interactive.r
\name{geom_bar_interactive}
\alias{geom_bar_interactive}
\title{interactive bars}
\usage{
geom_bar_interactive(mapping = NULL, data = NULL, stat = "count",
  position = "stack", ..., width = NULL, na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{The aesthetic mapping, see \code{\link[ggplot2]{geom_point}}.}

\item{data}{A data frame, see \code{\link[ggplot2]{geom_point}}.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string, see \code{\link[ggplot2]{geom_point}}.}

\item{position}{Postion adjustment, see \code{\link[ggplot2]{geom_point}}.}

\item{...}{other arguments passed on to layer. See \code{\link[ggplot2]{geom_point}}.}

\item{width}{Bar width.}

\item{na.rm}{See \code{\link[ggplot2]{geom_point}}.}

\item{show.legend}{See \code{\link[ggplot2]{geom_point}}.}

\item{inherit.aes}{See \code{\link[ggplot2]{geom_point}}.}
}
\description{
The geometry is based on \code{\link[ggplot2]{geom_bar}}.
See the documentation for those functions for more details.
}
\examples{
g <- ggplot(mpg, aes( x = class, tooltip = class,
        data_id = class ) ) +
  geom_bar_interactive()
ggiraph(code = print(g))

dat <- data.frame( name = c( "David", "Constance", "Leonie" ),
    gender = c( "Male", "Female", "Female" ),
    height = c(172, 159, 71 ) )
g <- ggplot(dat, aes( x = name, y = height, tooltip = gender,
        data_id = name ) ) +
  geom_bar_interactive(stat = "identity")
ggiraph(code = print(g))
}
\seealso{
\code{\link{ggiraph}}
}

