% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girafe_options.R
\name{opts_hover}
\alias{opts_hover}
\title{hover effect settings}
\usage{
opts_hover(css = NULL)
}
\arguments{
\item{css}{css to associate with elements to be animated
when mouse is hover them.}
}
\description{
Allows customization of the animation
of graphic elements on which the mouse is positioned.
}
\examples{
library(ggplot2)

dataset <- mtcars
dataset$carname = row.names(mtcars)

gg <- ggplot(
  data = dataset,
  mapping = aes(x = wt, y = qsec, color = disp,
                tooltip = carname, data_id = carname) ) +
  geom_point_interactive() + theme_minimal()

x <- girafe(ggobj = gg)
x <- girafe_options(x,
  opts_hover(css = "fill:wheat;stroke:orange;r:5pt;") )
if( interactive() ) print(x)
}
\seealso{
set options with \code{\link{girafe_options}}

Other girafe animation options: \code{\link{opts_selection}},
  \code{\link{opts_toolbar}}, \code{\link{opts_tooltip}},
  \code{\link{opts_zoom}}
}
\concept{girafe animation options}
