% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggCLE.R
\name{ggCLE}
\alias{ggCLE}
\title{Draw a cleveland dot plot}
\usage{
ggCLE(data, mapping, reorderByX = TRUE, no = NULL, start = 0.99,
  interactive = FALSE, decreasing = TRUE, ...)
}
\arguments{
\item{data}{a data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{reorderByX}{If true, the data is reordered by x variable}

\item{no}{Number of data be drawn in plot}

\item{start}{start point of x axis as ratio to minimum x variable}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}

\item{decreasing}{Should the sort order be increasing or decreasing?}

\item{...}{other arguments passed on to geom_point_interactive}
}
\description{
Draw a cleveland dot plot
}
\examples{
require(ggplot2)
require(ggiraph)
mtcars$name=rownames(mtcars)
ggCLE(data=mtcars,aes(x=mpg,y=name))
ggCLE(data=mtcars,aes(x=mpg,y=name,color=am,facet=am),interactive=TRUE)
if(requireNamespace("gcookbook",quietly=TRUE)){
   require(gcookbook)
   ggCLE(data=tophitters2001,aes(x=avg,y=name),no=20,interactive=TRUE)
   ggCLE(data=tophitters2001,aes(x=avg,y=name,color=lg,facet=lg),no=20)
}
}

