% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggViolin.R
\name{ggViolin}
\alias{ggViolin}
\title{Draw violin plots of a data.frame}
\usage{
ggViolin(data, mapping = NULL, rescale = FALSE, horizontal = FALSE,
  alpha = 0.1, addBoxplot = TRUE, addMean = TRUE, use.label = TRUE,
  use.labels = TRUE, ...)
}
\arguments{
\item{data}{a data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{rescale}{if true, rescale the data.frame}

\item{horizontal}{if true, horizontal boxplots will be made}

\item{alpha}{An integer. Default value is 0.1.}

\item{addBoxplot}{Whether add boxplots on the plot}

\item{addMean}{Whether add mean point on the plot}

\item{use.label}{Logical. Whether or not use column label in case of labelled data}

\item{use.labels}{Logical. Whether or not use value labels in case of labelled data}

\item{...}{other arguments passed on to geom_boxplot_interactive}
}
\description{
Draw violin plots of a data.frame
}
\examples{
require(ggplot2)
require(ggiraph)
require(reshape2)
ggViolin(iris)
ggViolin(iris,aes(fill=Species),rescale=TRUE)
ggViolin(mtcars,aes(x=c(mpg,cyl,disp,hp,drat),color=am),rescale=TRUE)
ggViolin(mtcars,aes(x=c(mpg,cyl,disp,hp,drat)),rescale=TRUE)
}
