% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_lgbtq}
\alias{theme_lgbtq}
\title{Use default theme for an LGBTQ palette}
\usage{
theme_lgbtq(name, ...)
}
\arguments{
\item{name}{\code{character(1)}\cr
Name of the flag the colors are based on.}

\item{...}{\code{ANY}\cr
Parameters passed to \code{\link[ggplot2]{theme}()}.}
}
\value{
A ggplot2 \code{theme} object.
}
\description{
Provides a default theme for a given palette. Most LGBTQ flags
contain white, for which the default light gray background of ggplot2 is too
light. Conversely, this same gray is too dark for flags with yellow stripes.
LGBTQ themes are carefully curated for each palette.
}
\section{Available palettes}{

Currently available palettes are:
\itemize{
\item \code{rainbow} (6 colors)
\item \code{philadelphia} (8 colors)
\item \code{progress} (11 colors)
\item \code{bisexual} (3 colors)
\item \code{asexual} (4 colors)
\item \code{transgender} (3 colors)
\item \code{pansexual} (3 colors)
\item \code{nonbinary} (4 colors)
\item \code{lesbian} (5 colors)
\item \code{gay_man} (5 colors)
\item \code{intersex} (2 colors)
\item \code{aromantic} (5 colors)
\item \code{genderfluid} (5 colors)
\item \code{genderqueer} (3 colors)
\item \code{lesbian_7} (7 colors)
\item \code{gay_man_7} (7 colors)
}
}

\examples{
library(ggplot2)
ggplot(data.frame(x = 1:10, y = 15:6,
                  group = rep(c("a", "b"), each = 5)),
       aes(x = x, y = y, color = group)) +
  geom_point(size = 4) +
  scale_color_manual(values = palette_lgbtq("intersex")) +
  # Use the same name as for values, preferably
  theme_lgbtq("intersex")

}
