% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.r
\name{getOutline}
\alias{getOutline}
\title{Determine boundary between foreground and background in an image}
\usage{
getOutline(imdf, var = "red", threshold = 0.5)
}
\arguments{
\item{imdf}{dataframe describing a pixellated image in x and y. Has to have columns x, y, and var}

\item{var}{dimension along which foreground and background of a shape in the image are well separated. Usually one of 'red', 'green', or 'blue', but could be extended to any other numerical variable.}

\item{threshold}{value specifying the cutoff along variable var. Values of var higher than the threshold are considered to belong to the foreground.}
}
\value{
subset of data frame imdf consisting of just boundary points:
\itemize{
\item x x coordinate in pixels
\item y y coordinate in pixels (usually negative)
\item red number vector in (0,1) describing the amount of red of the pixel in an RGB model
\item green number vector in (0,1) describing the amount of green of the pixel in an RGB model
\item blue number vector in (0,1) describing the amount of blue of the pixel in an RGB model
}
}
\description{
Determine boundary between foreground and background in an image
}
