% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_map.R
\name{get_map}
\alias{get_map}
\title{Grab a map.}
\usage{
get_map(location = c(lon = -95.3632715, lat = 29.7632836), zoom = "auto",
  scale = "auto", maptype = c("terrain", "terrain-background", "satellite",
  "roadmap", "hybrid", "toner", "watercolor", "terrain-labels", "terrain-lines",
  "toner-2010", "toner-2011", "toner-background", "toner-hybrid",
  "toner-labels", "toner-lines", "toner-lite"), source = c("google", "osm",
  "stamen", "cloudmade"), force = ifelse(source == "google", TRUE, TRUE),
  messaging = FALSE, urlonly = FALSE, filename = "ggmapTemp",
  crop = TRUE, color = c("color", "bw"), language = "en-EN", api_key)
}
\arguments{
\item{location}{an address, longitude/latitude pair (in that order), or
left/bottom/right/top bounding box}

\item{zoom}{map zoom, an integer from 3 (continent) to 21 (building), default
value 10 (city).  openstreetmaps limits a zoom of 18, and the limit on
stamen maps depends on the maptype.  "auto" automatically determines the
zoom for bounding box specifications, and is defaulted to 10 with
center/zoom specifications.  maps of the whole world currently not
supported.}

\item{scale}{scale argument of \code{\link{get_googlemap}} or
\code{\link{get_openstreetmap}}}

\item{maptype}{character string providing map theme. options available are
"terrain", "terrain-background", "satellite", "roadmap", and "hybrid"
(google maps), "terrain", "watercolor", and "toner" (stamen maps), or a
positive integer for cloudmade maps (see ?get_cloudmademap)}

\item{source}{Google Maps ("google"), OpenStreetMap ("osm"), Stamen Maps
("stamen"), or CloudMade maps ("cloudmade")}

\item{force}{force new map (don't use archived version)}

\item{messaging}{turn messaging on/off}

\item{urlonly}{return url only}

\item{filename}{destination file for download (file extension added according
to format)}

\item{crop}{(stamen and cloudmade maps) crop tiles to bounding box}

\item{color}{color ("color") or black-and-white ("bw")}

\item{language}{language for google maps}

\item{api_key}{an api key for cloudmade maps}
}
\value{
a ggmap object (a classed raster object with a bounding box
  attribute)
}
\description{
\code{get_map} is a smart wrapper that queries the Google Maps,
OpenStreetMap, Stamen Maps or Naver Map servers for a map.
}
\examples{
map <- get_map()
map
str(map)
ggmap(map)

\dontrun{
# not run by check to reduce time; also,
# osm may error due to server overload

(map <- get_map(maptype = "roadmap"))
(map <- get_map(source = "osm"))
(map <- get_map(source = "stamen", maptype = "watercolor"))

map <- get_map(location = "texas", zoom = 6, source = "stamen")
ggmap(map, fullpage = TRUE)

}
}
\author{
David Kahle \email{david.kahle@gmail.com}
}
\seealso{
\code{\link{ggmap}}, \code{\link{GetMap}} in package RgoogleMaps
}

