% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qmap.R
\name{qmap}
\alias{qmap}
\title{Quick map plot}
\usage{
qmap(location = "houston", ...)
}
\arguments{
\item{location}{character; location of interest}

\item{...}{stuff to pass to \code{\link{ggmap}} and
\code{\link{get_map}}.}
}
\value{
a ggplot object
}
\description{
qmap is a wrapper for \code{\link{ggmap}} and
\code{\link{get_map}}.
}
\examples{

\dontrun{ some requires Google API key; heavy network/time load

location <- "marrs mclean science, waco, texas"
qmap(location)
qmap(location, zoom = 14)
qmap(location, zoom = 14, source = "osm")
qmap(location, zoom = 14, source = "osm", scale = 20000)
qmap(location, zoom = 14, maptype = "satellite")
qmap(location, zoom = 14, maptype = "hybrid")
qmap(location, zoom = 14, maptype = "toner", source = "stamen")
qmap(location, zoom = 14, maptype = "watercolor", source = "stamen")
qmap(location, zoom = 14, maptype = "terrain-background", source = "stamen")
qmap(location, zoom = 14, maptype = "toner-lite", source = "stamen")

where <- "the white house, washington dc"
wh <- geocode(where)
qmap(where, maprange = TRUE, zoom = 15,
  base_layer = ggplot(aes(x=lon, y=lat), data = wh)) +
  geom_point()



}

}
\seealso{
\code{\link{ggmap}} and \code{\link{get_map}}.
}
\author{
David Kahle \email{david.kahle@gmail.com}
}
