% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MullerPlot.R
\name{move_up}
\alias{move_up}
\title{Move to parent in adjacency matrix}
\usage{
move_up(edges, identity)
}
\arguments{
\item{edges}{Dataframe comprising an adjacency matrix, with column names "Parent" and "Identity"}

\item{identity}{number or character string specifying daughter whose parent is to be found}
}
\value{
The Parent value.
}
\description{
Returns the corresponding Parent value. 
When there is no parent (i.e. at the top of the tree), returns the input Identity.
}
\examples{
edges1 <- data.frame(Parent = c(1,1,1,3,3), Identity = 2:6)
move_up(edges1, 3)

}
\seealso{
\code{\link{move_down}} \code{\link{move_right}}
}
\author{
Rob Noble, \email{robjohnnoble@gmail.com}
}
