% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_ordisurf.R
\name{gg_ordisurf}
\alias{gg_ordisurf}
\title{Ordisurf with ggplot2}
\usage{
gg_ordisurf(
  ord,
  env.var,
  groups = NA,
  choices = c(1, 2),
  var.label = "Level",
  binwidth,
  pt.size = 3,
  family = "gaussian",
  plot = TRUE
)
}
\arguments{
\item{ord}{An ordination object.}

\item{env.var}{Environmental variable to fit to plot.}

\item{groups}{A vector of groups (optional).}

\item{choices}{Axes to plot.}

\item{var.label}{Label for the contour legend; default is "Level."}

\item{binwidth}{Controls the number of contours in the plot.}

\item{pt.size}{Symbol size.}

\item{family}{Error distribution and link function used by the gam function to fit the contours.}

\item{plot}{A logical for plotting; defaults to TRUE.}
}
\value{
Silently returns the plot and data frames used for the plotting.
}
\description{
Fits a surface (contour) plot of an environmental variable
to an ordination plot.
}
\details{
By default, `binwidth` is calculated as the difference between minimum and maximum values of the variable divided by 15.

The colors for the points are mapped to fill; if you want to rename the legend for the groups (points), use labs(fill="New name").

See the help for stats::family for possible values for family.
}
\note{
Code for extracting plot data from the ordisurf result was taken from a blog by Oliviea Rata Burge.
}
\examples{
data(varespec)
data(varechem)
vare.dist <- vegdist(varespec)
vare.mds <- monoMDS(vare.dist)
gg_ordisurf(vare.mds, env.var = varechem$Baresoil, var.label="Bare Soil")
}
\references{
https://oliviarata.wordpress.com/2014/07/17/ordinations-in-ggplot2-v2-ordisurf/'
}
\author{
Olivia Rata Burge, John Quensen
}
