% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpacket.R
\name{ggpacket}
\alias{ggpacket}
\title{A container for lazy ggplot layers}
\usage{
ggpacket(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=ggpacket_call]{ggpacket_call}}
  \describe{
    \item{\code{data}}{The data argument to use for all layers within the
\code{ggpacket}}
    \item{\code{mapping}}{The aesthetic mapping to use as a basis for all layers within
the \code{ggpacket}. Layer-specific mappings will update the value of the
mapping, and assigning \code{..reset..} to any aesthetic field will return
the propegated aesthetic mapping to a default, unmapped state for that
layer.}
    \item{\code{.id}}{an optional identifier tag for the \code{ggpacket}, used for
filtering arguments and aesthetics that are propegated into the contained
\code{ggplot} layers.}
  }}
}
\value{
A new \code{ggpacket} object
}
\description{
\code{ggpacket}s present a mechanism for easily collecting loose ggplot
layers into objects that can be reused across multiple plots, as well as
handling of hierarchical argument propegation, as well as data and aesthetic
scoping.
}
\details{
The \code{ggpacket} object behaves like a function, returning an updated
\code{ggpacket}. As well, it contains a few slots which can be used for
programmatically accessing the lazy ggplot calls.

Within \code{ggpacket} and subsequent \code{ggplot} layer calls, aesthetic
mappings can contain references to previously mapped aesthetics using the
double-dot keywords (e.g. \code{..x..}). In addition, the keyword
\code{..reset..} can be used to revert aesthetics within the \code{ggpacket}
or layer to an un-specified state.

Because \code{ggpacket}s will tolerate a more flexible syntax for layer
specifications, it's preferrable to use the \code{ggplot} composition
operator \code{\%+\%} (instead of \code{+}). This allows for duplicate
argument names and non-standard aesthetics to be passed, which are both
handled internally within the \code{ggpacket} call, but will trigger
warnings when using a bare \code{+}.
}
\section{Slots}{

\describe{
\item{\code{data}}{A lazy reference to the \code{data} parameter of the
\code{ggpacket}, allowing for scoping the data used by a block of
\code{ggplot} layers.}

\item{\code{mapping}}{A lazy reference to the \code{mapping} parameter of the
\code{ggpacket}, allowing for scoping of aesthetic mappings over a block of
\code{ggplot} layers.}

\item{\code{dots}}{Quosures representing arguments to be passed to all of the
\code{ggpacket}'s \code{ggplot} layers.}

\item{\code{ggcalls}}{A list containing the layers stored within the \code{ggpacket}}
}}

\examples{
library(ggplot2)

# create a ggpacket directly, setting some fixed argument settings
ggpk_simple <- ggpacket() \%+\% geom_line(color = "red") \%+\% geom_point()
ggplot(mtcars, aes(x = wt, y = mpg)) + ggpk_simple()

# any non-fixed arguments can be modified in the ggpacket call
ggplot(mtcars, aes(x = wt, y = mpg)) + ggpk_simple(color = "green")

# arguments can be specified for only specific layers by prefixing them
ggplot(mtcars, aes(x = wt, y = mpg)) + ggpk_simple(point.size = 5)

# allow masking of preset arguments by wrapping the ggpacket in a function
ggpk_func <- function(...) {
  ggpacket() \%+\%
    geom_line(...) \%+\%
    geom_point(color = "red", ...)
}

ggplot(mtcars, aes(x = wt, y = mpg)) +
  ggpk_func(color = "purple", size = 2, point.size = 4)

}
