#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# All functions in this file are auto-generated by the script:
#     'data-raw/generate-scales.R'
#
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' Scales for continuous pattern aesthetics
#'
#' @param name,breaks,labels,limits,range,trans,guide,... See
#'        \code{{ggplot2}} documentation for more information on scales.
#'
#' @return A [ggplot2::Scale] object.
#' @examples
#'   if (require('ggplot2')) {
#'
#'     # 'stripe' pattern example
#'     df <- data.frame(level = c('a', 'b', 'c', 'd'),
#'                      outcome = c(2.3, 1.9, 3.2, 1))
#'     gg <- ggplot(df) +
#'       geom_col_pattern(
#'         aes(level, outcome, pattern_fill = level,
#'             pattern_density = outcome),
#'         pattern = 'stripe',
#'         fill    = 'white',
#'         colour  = 'black'
#'       ) +
#'       theme_bw(18) +
#'       theme(legend.position = 'none') +
#'       scale_pattern_density_continuous(range = c(0.1, 0.6)) +
#'       labs(
#'         title    = 'ggpattern::geom_col_pattern()',
#'         subtitle = 'pattern = \'stripe\''
#'       )
#'     plot(gg)
#'   }
#' @name scale_continuous
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
NULL


#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' Scales for discrete pattern aesthetics
#'
#' @param choices vector of values to choose from.
#' @param name,breaks,labels,limits,trans,guide,... See
#'        \code{{ggplot2}} documentation for more information on scales.
#'
#' @return A [ggplot2::Scale] object.
#' @examples
#'   if (require('ggplot2')) {
#'     gg <- ggplot(mtcars) +
#'        geom_density_pattern(
#'          aes(
#'            x            = mpg,
#'            pattern_fill = as.factor(cyl),
#'            pattern_type = as.factor(cyl)
#'          ),
#'          pattern = 'polygon_tiling',
#'          pattern_key_scale_factor = 1.2
#'        ) +
#'        scale_pattern_type_discrete(choices = gridpattern::names_polygon_tiling) +
#'        theme_bw(18) +
#'        theme(legend.key.size = unit(2, 'cm')) +
#'        labs(
#'          title    = 'ggpattern::geom_density_pattern()',
#'          subtitle = 'pattern = \'polygon_tiling\''
#'        )
#'     plot(gg)
#'   }
#' @name scale_discrete
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
NULL
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_continuous <- function(name = waiver(), breaks = waiver(), labels = waiver(),
                                     limits = NULL, choices = c('stripe', 'crosshatch', 'circle'),
                                     trans = 'identity', guide = 'legend') {


  if (is.null(choices)) {
     abort('scale_pattern_continuous(): must specify "choices" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern',
    scale_name = 'pattern',
    palette    = function(x) choices[as.integer(x * (length(choices) - 1) + 1)],
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide)
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @importFrom utils head
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_discrete <- function(..., choices = c('stripe', 'crosshatch', 'circle'), guide = 'legend') {
  force(range)

  if (is.null(choices)) {
     abort('scale_pattern_discrete(): must specify "choices" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern',
    scale_name = 'pattern',
    palette    = function(n) {
      idx <- cut(seq(n), length(choices), labels = FALSE, include.lowest = TRUE)
      choices[idx]
    },
    guide = guide,
    ...
  )
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_type_continuous <- function(name = waiver(), breaks = waiver(), labels = waiver(),
                                     limits = NULL, choices = NULL,
                                     trans = 'identity', guide = 'legend') {


  if (is.null(choices)) {
     abort('scale_pattern_type_continuous(): must specify "choices" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_type',
    scale_name = 'pattern_type',
    palette    = function(x) choices[as.integer(x * (length(choices) - 1) + 1)],
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide)
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @importFrom utils head
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_type_discrete <- function(..., choices = NULL, guide = 'legend') {
  force(range)

  if (is.null(choices)) {
     abort('scale_pattern_type_discrete(): must specify "choices" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_type',
    scale_name = 'pattern_type',
    palette    = function(n) {
      idx <- cut(seq(n), length(choices), labels = FALSE, include.lowest = TRUE)
      choices[idx]
    },
    guide = guide,
    ...
  )
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_subtype_continuous <- function(name = waiver(), breaks = waiver(), labels = waiver(),
                                     limits = NULL, choices = NULL,
                                     trans = 'identity', guide = 'legend') {


  if (is.null(choices)) {
     abort('scale_pattern_subtype_continuous(): must specify "choices" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_subtype',
    scale_name = 'pattern_subtype',
    palette    = function(x) choices[as.integer(x * (length(choices) - 1) + 1)],
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide)
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @importFrom utils head
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_subtype_discrete <- function(..., choices = NULL, guide = 'legend') {
  force(range)

  if (is.null(choices)) {
     abort('scale_pattern_subtype_discrete(): must specify "choices" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_subtype',
    scale_name = 'pattern_subtype',
    palette    = function(n) {
      idx <- cut(seq(n), length(choices), labels = FALSE, include.lowest = TRUE)
      choices[idx]
    },
    guide = guide,
    ...
  )
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_angle_continuous <- function(name   = waiver(),
                                        breaks = waiver(),
                                        labels = waiver(),
                                        limits = NULL,
                                        range  = c(0, 90),
                                        trans  = 'identity',
                                        guide  = 'legend') {


  if (is.null(range)) {
     abort('scale_pattern_angle_continuous(): must specify "range" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_angle',
    scale_name = 'pattern_angle',
    palette    = scales::rescale_pal(range),
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_angle_discrete <- function(..., range = c(0, 90)) {
  force(range)

  if (is.null(range)) {
     abort('scale_pattern_angle_discrete(): must specify "range" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_angle',
    scale_name = 'pattern_angle',
    palette    = function(n) seq(range[1], range[2], length.out = n),
    guide      = 'legend',
    ...
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_density_continuous <- function(name   = waiver(),
                                        breaks = waiver(),
                                        labels = waiver(),
                                        limits = NULL,
                                        range  = c(0, 0.5),
                                        trans  = 'identity',
                                        guide  = 'legend') {


  if (is.null(range)) {
     abort('scale_pattern_density_continuous(): must specify "range" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_density',
    scale_name = 'pattern_density',
    palette    = scales::rescale_pal(range),
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_density_discrete <- function(..., range = c(0, 0.5)) {
  force(range)

  if (is.null(range)) {
     abort('scale_pattern_density_discrete(): must specify "range" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_density',
    scale_name = 'pattern_density',
    palette    = function(n) seq(range[1], range[2], length.out = n),
    guide      = 'legend',
    ...
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_spacing_continuous <- function(name   = waiver(),
                                        breaks = waiver(),
                                        labels = waiver(),
                                        limits = NULL,
                                        range  = c(0.01, 0.1),
                                        trans  = 'identity',
                                        guide  = 'legend') {


  if (is.null(range)) {
     abort('scale_pattern_spacing_continuous(): must specify "range" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_spacing',
    scale_name = 'pattern_spacing',
    palette    = scales::rescale_pal(range),
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_spacing_discrete <- function(..., range = c(0.01, 0.1)) {
  force(range)

  if (is.null(range)) {
     abort('scale_pattern_spacing_discrete(): must specify "range" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_spacing',
    scale_name = 'pattern_spacing',
    palette    = function(n) seq(range[1], range[2], length.out = n),
    guide      = 'legend',
    ...
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_xoffset_continuous <- function(name   = waiver(),
                                        breaks = waiver(),
                                        labels = waiver(),
                                        limits = NULL,
                                        range  = c(0.01, 0.1),
                                        trans  = 'identity',
                                        guide  = 'legend') {


  if (is.null(range)) {
     abort('scale_pattern_xoffset_continuous(): must specify "range" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_xoffset',
    scale_name = 'pattern_xoffset',
    palette    = scales::rescale_pal(range),
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_xoffset_discrete <- function(..., range = c(0.01, 0.1)) {
  force(range)

  if (is.null(range)) {
     abort('scale_pattern_xoffset_discrete(): must specify "range" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_xoffset',
    scale_name = 'pattern_xoffset',
    palette    = function(n) seq(range[1], range[2], length.out = n),
    guide      = 'legend',
    ...
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_yoffset_continuous <- function(name   = waiver(),
                                        breaks = waiver(),
                                        labels = waiver(),
                                        limits = NULL,
                                        range  = c(0.01, 0.1),
                                        trans  = 'identity',
                                        guide  = 'legend') {


  if (is.null(range)) {
     abort('scale_pattern_yoffset_continuous(): must specify "range" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_yoffset',
    scale_name = 'pattern_yoffset',
    palette    = scales::rescale_pal(range),
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_yoffset_discrete <- function(..., range = c(0.01, 0.1)) {
  force(range)

  if (is.null(range)) {
     abort('scale_pattern_yoffset_discrete(): must specify "range" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_yoffset',
    scale_name = 'pattern_yoffset',
    palette    = function(n) seq(range[1], range[2], length.out = n),
    guide      = 'legend',
    ...
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_aspect_ratio_continuous <- function(name   = waiver(),
                                        breaks = waiver(),
                                        labels = waiver(),
                                        limits = NULL,
                                        range  = c(0.5, 2),
                                        trans  = 'identity',
                                        guide  = 'legend') {


  if (is.null(range)) {
     abort('scale_pattern_aspect_ratio_continuous(): must specify "range" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_aspect_ratio',
    scale_name = 'pattern_aspect_ratio',
    palette    = scales::rescale_pal(range),
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_aspect_ratio_discrete <- function(..., range = c(0.5, 2)) {
  force(range)

  if (is.null(range)) {
     abort('scale_pattern_aspect_ratio_discrete(): must specify "range" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_aspect_ratio',
    scale_name = 'pattern_aspect_ratio',
    palette    = function(n) seq(range[1], range[2], length.out = n),
    guide      = 'legend',
    ...
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_key_scale_factor_continuous <- function(name   = waiver(),
                                        breaks = waiver(),
                                        labels = waiver(),
                                        limits = NULL,
                                        range  = c(0.5, 2),
                                        trans  = 'identity',
                                        guide  = 'legend') {


  if (is.null(range)) {
     abort('scale_pattern_key_scale_factor_continuous(): must specify "range" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_key_scale_factor',
    scale_name = 'pattern_key_scale_factor',
    palette    = scales::rescale_pal(range),
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_key_scale_factor_discrete <- function(..., range = c(0.5, 2)) {
  force(range)

  if (is.null(range)) {
     abort('scale_pattern_key_scale_factor_discrete(): must specify "range" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_key_scale_factor',
    scale_name = 'pattern_key_scale_factor',
    palette    = function(n) seq(range[1], range[2], length.out = n),
    guide      = 'legend',
    ...
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_filename_continuous <- function(name = waiver(), breaks = waiver(), labels = waiver(),
                                     limits = NULL, choices = NULL,
                                     trans = 'identity', guide = 'legend') {


  if (is.null(choices)) {
     abort('scale_pattern_filename_continuous(): must specify "choices" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_filename',
    scale_name = 'pattern_filename',
    palette    = function(x) choices[as.integer(x * (length(choices) - 1) + 1)],
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide)
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @importFrom utils head
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_filename_discrete <- function(..., choices = NULL, guide = 'legend') {
  force(range)

  if (is.null(choices)) {
     abort('scale_pattern_filename_discrete(): must specify "choices" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_filename',
    scale_name = 'pattern_filename',
    palette    = function(n) {
      idx <- cut(seq(n), length(choices), labels = FALSE, include.lowest = TRUE)
      choices[idx]
    },
    guide = guide,
    ...
  )
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_filter_continuous <- function(name = waiver(), breaks = waiver(), labels = waiver(),
                                     limits = NULL, choices = c('lanczos', 'box', 'spline', 'cubic'),
                                     trans = 'identity', guide = 'legend') {


  if (is.null(choices)) {
     abort('scale_pattern_filter_continuous(): must specify "choices" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_filter',
    scale_name = 'pattern_filter',
    palette    = function(x) choices[as.integer(x * (length(choices) - 1) + 1)],
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide)
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @importFrom utils head
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_filter_discrete <- function(..., choices = c('lanczos', 'box', 'spline', 'cubic'), guide = 'legend') {
  force(range)

  if (is.null(choices)) {
     abort('scale_pattern_filter_discrete(): must specify "choices" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_filter',
    scale_name = 'pattern_filter',
    palette    = function(n) {
      idx <- cut(seq(n), length(choices), labels = FALSE, include.lowest = TRUE)
      choices[idx]
    },
    guide = guide,
    ...
  )
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_gravity_continuous <- function(name = waiver(), breaks = waiver(), labels = waiver(),
                                     limits = NULL, choices = c('center', 'north', 'south', 'east', 'west', 'northeast', 'northwest', 'southeast', 'southwest'),
                                     trans = 'identity', guide = 'legend') {


  if (is.null(choices)) {
     abort('scale_pattern_gravity_continuous(): must specify "choices" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_gravity',
    scale_name = 'pattern_gravity',
    palette    = function(x) choices[as.integer(x * (length(choices) - 1) + 1)],
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide)
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @importFrom utils head
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_gravity_discrete <- function(..., choices = c('center', 'north', 'south', 'east', 'west', 'northeast', 'northwest', 'southeast', 'southwest'), guide = 'legend') {
  force(range)

  if (is.null(choices)) {
     abort('scale_pattern_gravity_discrete(): must specify "choices" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_gravity',
    scale_name = 'pattern_gravity',
    palette    = function(n) {
      idx <- cut(seq(n), length(choices), labels = FALSE, include.lowest = TRUE)
      choices[idx]
    },
    guide = guide,
    ...
  )
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_scale_continuous <- function(name   = waiver(),
                                        breaks = waiver(),
                                        labels = waiver(),
                                        limits = NULL,
                                        range  = c(0.5, 2),
                                        trans  = 'identity',
                                        guide  = 'legend') {


  if (is.null(range)) {
     abort('scale_pattern_scale_continuous(): must specify "range" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_scale',
    scale_name = 'pattern_scale',
    palette    = scales::rescale_pal(range),
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_scale_discrete <- function(..., range = c(0.5, 2)) {
  force(range)

  if (is.null(range)) {
     abort('scale_pattern_scale_discrete(): must specify "range" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_scale',
    scale_name = 'pattern_scale',
    palette    = function(n) seq(range[1], range[2], length.out = n),
    guide      = 'legend',
    ...
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_orientation_continuous <- function(name = waiver(), breaks = waiver(), labels = waiver(),
                                     limits = NULL, choices = c('horizontal', 'vertical', 'radial'),
                                     trans = 'identity', guide = 'legend') {


  if (is.null(choices)) {
     abort('scale_pattern_orientation_continuous(): must specify "choices" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_orientation',
    scale_name = 'pattern_orientation',
    palette    = function(x) choices[as.integer(x * (length(choices) - 1) + 1)],
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide)
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @importFrom utils head
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_orientation_discrete <- function(..., choices = c('horizontal', 'vertical', 'radial'), guide = 'legend') {
  force(range)

  if (is.null(choices)) {
     abort('scale_pattern_orientation_discrete(): must specify "choices" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_orientation',
    scale_name = 'pattern_orientation',
    palette    = function(n) {
      idx <- cut(seq(n), length(choices), labels = FALSE, include.lowest = TRUE)
      choices[idx]
    },
    guide = guide,
    ...
  )
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_phase_continuous <- function(name   = waiver(),
                                        breaks = waiver(),
                                        labels = waiver(),
                                        limits = NULL,
                                        range  = NULL,
                                        trans  = 'identity',
                                        guide  = 'legend') {


  if (is.null(range)) {
     abort('scale_pattern_phase_continuous(): must specify "range" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_phase',
    scale_name = 'pattern_phase',
    palette    = scales::rescale_pal(range),
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_phase_discrete <- function(..., range = NULL) {
  force(range)

  if (is.null(range)) {
     abort('scale_pattern_phase_discrete(): must specify "range" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_phase',
    scale_name = 'pattern_phase',
    palette    = function(n) seq(range[1], range[2], length.out = n),
    guide      = 'legend',
    ...
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_frequency_continuous <- function(name   = waiver(),
                                        breaks = waiver(),
                                        labels = waiver(),
                                        limits = NULL,
                                        range  = NULL,
                                        trans  = 'identity',
                                        guide  = 'legend') {


  if (is.null(range)) {
     abort('scale_pattern_frequency_continuous(): must specify "range" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_frequency',
    scale_name = 'pattern_frequency',
    palette    = scales::rescale_pal(range),
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_frequency_discrete <- function(..., range = NULL) {
  force(range)

  if (is.null(range)) {
     abort('scale_pattern_frequency_discrete(): must specify "range" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_frequency',
    scale_name = 'pattern_frequency',
    palette    = function(n) seq(range[1], range[2], length.out = n),
    guide      = 'legend',
    ...
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_grid_continuous <- function(name = waiver(), breaks = waiver(), labels = waiver(),
                                     limits = NULL, choices = c('square', 'hex'),
                                     trans = 'identity', guide = 'legend') {


  if (is.null(choices)) {
     abort('scale_pattern_grid_continuous(): must specify "choices" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_grid',
    scale_name = 'pattern_grid',
    palette    = function(x) choices[as.integer(x * (length(choices) - 1) + 1)],
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide)
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_discrete
#' @importFrom utils head
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_grid_discrete <- function(..., choices = c('square', 'hex'), guide = 'legend') {
  force(range)

  if (is.null(choices)) {
     abort('scale_pattern_grid_discrete(): must specify "choices" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_grid',
    scale_name = 'pattern_grid',
    palette    = function(n) {
      idx <- cut(seq(n), length(choices), labels = FALSE, include.lowest = TRUE)
      choices[idx]
    },
    guide = guide,
    ...
  )
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_res_continuous <- function(name   = waiver(),
                                        breaks = waiver(),
                                        labels = waiver(),
                                        limits = NULL,
                                        range  = NULL,
                                        trans  = 'identity',
                                        guide  = 'legend') {


  if (is.null(range)) {
     abort('scale_pattern_res_continuous(): must specify "range" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_res',
    scale_name = 'pattern_res',
    palette    = scales::rescale_pal(range),
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_res_discrete <- function(..., range = NULL) {
  force(range)

  if (is.null(range)) {
     abort('scale_pattern_res_discrete(): must specify "range" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_res',
    scale_name = 'pattern_res',
    palette    = function(n) seq(range[1], range[2], length.out = n),
    guide      = 'legend',
    ...
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_rot_continuous <- function(name   = waiver(),
                                        breaks = waiver(),
                                        labels = waiver(),
                                        limits = NULL,
                                        range  = c(0, 360),
                                        trans  = 'identity',
                                        guide  = 'legend') {


  if (is.null(range)) {
     abort('scale_pattern_rot_continuous(): must specify "range" argument')
  }

  ggplot2::continuous_scale(
    aesthetics = 'pattern_rot',
    scale_name = 'pattern_rot',
    palette    = scales::rescale_pal(range),
    name       = name,
    breaks     = breaks,
    labels     = labels,
    limits     = limits,
    trans      = trans,
    guide      = guide
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_continuous
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_rot_discrete <- function(..., range = c(0, 360)) {
  force(range)

  if (is.null(range)) {
     abort('scale_pattern_rot_discrete(): must specify "range" argument')
  }

  ggplot2::discrete_scale(
    aesthetics = 'pattern_rot',
    scale_name = 'pattern_rot',
    palette    = function(n) seq(range[1], range[2], length.out = n),
    guide      = 'legend',
    ...
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' Create your own discrete scale
#'
#' @param ...,values,breaks See \code{ggplot2} for documentation on manual scales.
#'        e.g. \code{ggplot2::scale_colour_manual()}
#' @return A [ggplot2::Scale] object.
#' @examples
#'   if (require('ggplot2')) {
#'     gg <- ggplot(mtcars) +
#'        geom_density_pattern(
#'          aes(
#'            x            = mpg,
#'            pattern_fill = as.factor(cyl),
#'            pattern_type = as.factor(cyl)
#'          ),
#'          pattern = 'polygon_tiling',
#'          pattern_key_scale_factor = 1.2
#'        ) +
#'        scale_pattern_type_manual(values = c('hexagonal', 'rhombille',
#'                                   'pythagorean')) +
#'        theme_bw(18) +
#'        theme(legend.key.size = unit(2, 'cm')) +
#'        labs(
#'          title    = 'ggpattern::geom_density_pattern()',
#'          subtitle = 'pattern = \'polygon_tiling\''
#'        )
#'     plot(gg)
#'   }
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_type_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_type', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_subtype_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_subtype', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_angle_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_angle', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_density_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_density', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_spacing_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_spacing', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_xoffset_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_xoffset', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_yoffset_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_yoffset', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_alpha_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_alpha', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_linetype_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_linetype', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_size_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_size', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_shape_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_shape', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_colour_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_colour', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_fill_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_fill', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_fill2_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_fill2', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_aspect_ratio_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_aspect_ratio', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_key_scale_factor_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_key_scale_factor', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_filename_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_filename', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_filter_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_filter', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_gravity_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_gravity', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_scale_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_scale', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_orientation_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_orientation', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_phase_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_phase', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_frequency_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_frequency', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_grid_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_grid', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_res_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_res', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_manual
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_rot_manual <- function(..., values, breaks = waiver()) {
  manual_scale('pattern_rot', values, breaks, ...)
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' Use values without scaling
#'
#' @param ...,guide See \code{ggplot2} for documentation on identity scales.
#'        e.g. \code{ggplot2::scale_alpha_identity()}
#'
#' @return A [ggplot2::Scale] object.
#' @examples
#'   if (require('ggplot2')) {
#'     df <- data.frame(outcome = c(2.3, 1.9, 3.2, 1),
#'                      pattern_type = sample(gridpattern::names_polygon_tiling, 4))
#'     gg <- ggplot(df) +
#'       geom_col_pattern(
#'         aes(pattern_type, outcome, pattern_fill = pattern_type,
#'             pattern_type = pattern_type),
#'         colour  = 'black',
#'         pattern = 'polygon_tiling',
#'         pattern_key_scale_factor = 1.2
#'        ) +
#'        scale_pattern_type_identity() +
#'        theme_bw(18) +
#'        theme(legend.position = 'none') +
#'        labs(
#'          x        = 'level',
#'          title    = 'ggpattern::geom_col_pattern()',
#'          subtitle = 'pattern = \'polygon_tiling\''
#'        )
#'     plot(gg)
#'   }
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_identity <- function(..., guide = 'none') {
  discrete_scale(
    aesthetics = 'pattern',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleDiscreteIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_type_identity <- function(..., guide = 'none') {
  discrete_scale(
    aesthetics = 'pattern_type',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleDiscreteIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_subtype_identity <- function(..., guide = 'none') {
  discrete_scale(
    aesthetics = 'pattern_subtype',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleDiscreteIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_angle_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_angle',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_density_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_density',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_spacing_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_spacing',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_xoffset_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_xoffset',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_yoffset_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_yoffset',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_alpha_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_alpha',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_linetype_identity <- function(..., guide = 'none') {
  discrete_scale(
    aesthetics = 'pattern_linetype',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleDiscreteIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_size_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_size',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_shape_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_shape',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_colour_identity <- function(..., guide = 'none') {
  discrete_scale(
    aesthetics = 'pattern_colour',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleDiscreteIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_fill_identity <- function(..., guide = 'none') {
  discrete_scale(
    aesthetics = 'pattern_fill',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleDiscreteIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_fill2_identity <- function(..., guide = 'none') {
  discrete_scale(
    aesthetics = 'pattern_fill2',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleDiscreteIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_aspect_ratio_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_aspect_ratio',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_key_scale_factor_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_key_scale_factor',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_filename_identity <- function(..., guide = 'none') {
  discrete_scale(
    aesthetics = 'pattern_filename',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleDiscreteIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_filter_identity <- function(..., guide = 'none') {
  discrete_scale(
    aesthetics = 'pattern_filter',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleDiscreteIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_gravity_identity <- function(..., guide = 'none') {
  discrete_scale(
    aesthetics = 'pattern_gravity',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleDiscreteIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_scale_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_scale',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_orientation_identity <- function(..., guide = 'none') {
  discrete_scale(
    aesthetics = 'pattern_orientation',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleDiscreteIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_phase_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_phase',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_frequency_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_frequency',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_grid_identity <- function(..., guide = 'none') {
  discrete_scale(
    aesthetics = 'pattern_grid',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleDiscreteIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_res_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_res',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#' @rdname scale_pattern_identity
#' @export
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
scale_pattern_rot_identity <- function(..., guide = 'none') {
  continuous_scale(
    aesthetics = 'pattern_rot',
    scale_name = 'identity',
    palette    = identity_pal(),
    ...,
    guide      = guide,
    super      = ScaleContinuousIdentity
  )
}
