% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-pattern.R
\name{scale_continuous}
\alias{scale_continuous}
\alias{scale_pattern_angle_continuous}
\alias{scale_pattern_angle_discrete}
\alias{scale_pattern_density_continuous}
\alias{scale_pattern_density_discrete}
\alias{scale_pattern_spacing_continuous}
\alias{scale_pattern_spacing_discrete}
\alias{scale_pattern_xoffset_continuous}
\alias{scale_pattern_xoffset_discrete}
\alias{scale_pattern_yoffset_continuous}
\alias{scale_pattern_yoffset_discrete}
\alias{scale_pattern_aspect_ratio_continuous}
\alias{scale_pattern_aspect_ratio_discrete}
\alias{scale_pattern_key_scale_factor_continuous}
\alias{scale_pattern_key_scale_factor_discrete}
\alias{scale_pattern_scale_continuous}
\alias{scale_pattern_scale_discrete}
\alias{scale_pattern_phase_continuous}
\alias{scale_pattern_phase_discrete}
\alias{scale_pattern_frequency_continuous}
\alias{scale_pattern_frequency_discrete}
\alias{scale_pattern_res_continuous}
\alias{scale_pattern_res_discrete}
\alias{scale_pattern_rot_continuous}
\alias{scale_pattern_rot_discrete}
\title{Scales for continuous pattern aesthetics}
\usage{
scale_pattern_angle_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = c(0, 90),
  trans = "identity",
  guide = "legend"
)

scale_pattern_angle_discrete(..., range = c(0, 90))

scale_pattern_density_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = c(0, 0.5),
  trans = "identity",
  guide = "legend"
)

scale_pattern_density_discrete(..., range = c(0, 0.5))

scale_pattern_spacing_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = c(0.01, 0.1),
  trans = "identity",
  guide = "legend"
)

scale_pattern_spacing_discrete(..., range = c(0.01, 0.1))

scale_pattern_xoffset_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = c(0.01, 0.1),
  trans = "identity",
  guide = "legend"
)

scale_pattern_xoffset_discrete(..., range = c(0.01, 0.1))

scale_pattern_yoffset_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = c(0.01, 0.1),
  trans = "identity",
  guide = "legend"
)

scale_pattern_yoffset_discrete(..., range = c(0.01, 0.1))

scale_pattern_aspect_ratio_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = c(0.5, 2),
  trans = "identity",
  guide = "legend"
)

scale_pattern_aspect_ratio_discrete(..., range = c(0.5, 2))

scale_pattern_key_scale_factor_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = c(0.5, 2),
  trans = "identity",
  guide = "legend"
)

scale_pattern_key_scale_factor_discrete(..., range = c(0.5, 2))

scale_pattern_scale_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = c(0.5, 2),
  trans = "identity",
  guide = "legend"
)

scale_pattern_scale_discrete(..., range = c(0.5, 2))

scale_pattern_phase_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = NULL,
  trans = "identity",
  guide = "legend"
)

scale_pattern_phase_discrete(..., range = NULL)

scale_pattern_frequency_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = NULL,
  trans = "identity",
  guide = "legend"
)

scale_pattern_frequency_discrete(..., range = NULL)

scale_pattern_res_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = NULL,
  trans = "identity",
  guide = "legend"
)

scale_pattern_res_discrete(..., range = NULL)

scale_pattern_rot_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = c(0, 360),
  trans = "identity",
  guide = "legend"
)

scale_pattern_rot_discrete(..., range = c(0, 360))
}
\arguments{
\item{name, breaks, labels, limits, range, trans, guide, ...}{See
\code{{ggplot2}} documentation for more information on scales.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} object.
}
\description{
Scales for continuous pattern aesthetics
}
\examples{
  if (require('ggplot2')) {

    # 'stripe' pattern example
    df <- data.frame(level = c('a', 'b', 'c', 'd'),
                     outcome = c(2.3, 1.9, 3.2, 1))
    gg <- ggplot(df) +
      geom_col_pattern(
        aes(level, outcome, pattern_fill = level,
            pattern_density = outcome),
        pattern = 'stripe',
        fill    = 'white',
        colour  = 'black'
      ) +
      theme_bw(18) +
      theme(legend.position = 'none') +
      scale_pattern_density_continuous(range = c(0.1, 0.6)) +
      labs(
        title    = 'ggpattern::geom_col_pattern()',
        subtitle = 'pattern = \'stripe\''
      )
    plot(gg)
  }
}
