% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/periodic.R
\name{periodic}
\alias{periodic}
\alias{periodic.default}
\alias{periodic.data.frame}
\alias{setperiodic}
\title{Add or remove periodic variables}
\usage{
periodic(object, ...)

\method{periodic}{default}(object, period, ...)

\method{periodic}{data.frame}(object, ...)

setperiodic(object, ...)
}
\arguments{
\item{object}{the object to coerce to periodic}

\item{...}{name-value pairs of expressions defining the period}

\item{period}{a numeric vector whose range defines the period}
}
\value{
An object of subclass \code{periodic_df} or \code{periodic_v}.

If \code{object} is of class \code{data.table}, then it will modify the object by
reference. To modify this behaviour, use
\code{options(ggperiodic.data.table.copy = TRUE)}. \code{setperiodic()} will modify a
\code{data.table} by reference bypassing the global option.
}
\description{
Creates a periodic object by specifying the periodic variables and their
periods.
}
\examples{
library(ggplot2)

x <- seq(0, 360 - 20, by = 20)
df <- data.frame(x = x, y = cos(x*pi/180))
df_p <- periodic(df, x = c(0, 360))

ggplot(df_p, aes(x, y)) +
   geom_line() +            # periodic data
   geom_point(data = df)    # non periodic data

# Extend domain
ggplot(df_p, aes(x, y), x = c(-180, 540)) +
   geom_line() +
   geom_point(data = df)

# with non regular intervals
x <- runif(30, 0, 360)
df <- periodic(data.frame(x = x, y = cos(x*pi/180)),
               x = c(0, 360))
ggplot(df, aes(x, y), x = c(-180, 540)) +
   geom_point()

}
