% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_annotation.R
\name{pathway_annotation}
\alias{pathway_annotation}
\title{Pathway information annotation of "EC", "KO", "MetaCyc" pathway}
\usage{
pathway_annotation(
  file = NULL,
  pathway = NULL,
  daa_results_df = NULL,
  ko_to_kegg = FALSE
)
}
\arguments{
\item{file}{A character, address to store PICRUSt2 export files. Provide this parameter when using the function for the first use case.}

\item{pathway}{A character, consisting of "EC", "KO", "MetaCyc"}

\item{daa_results_df}{A data frame, output of pathway_daa. Provide this parameter when using the function for the second use case.}

\item{ko_to_kegg}{A logical, decide if convert KO abundance to KEGG pathway abundance. Default is FALSE. Set to TRUE when using the function for the second use case.}
}
\value{
A data frame containing pathway annotation information. The data frame has the following columns:
\itemize{
  \item \code{feature}: The feature ID of the pathway (e.g., KO, EC, or MetaCyc ID).
  \item \code{description}: The description or name of the pathway.
  \item Other columns depending on the input parameters and type of pathway.
}
If \code{ko_to_kegg} is set to TRUE, the output data frame will also include the following columns:
\itemize{
  \item \code{pathway_name}: The name of the KEGG pathway.
  \item \code{pathway_description}: The description of the KEGG pathway.
  \item \code{pathway_class}: The class of the KEGG pathway.
  \item \code{pathway_map}: The KEGG pathway map ID.
}
}
\description{
This function has two primary use cases:
1. Annotating pathway information using the output file from PICRUSt2.
2. Annotating pathway information from the output of `pathway_daa` function, and converting KO abundance to KEGG pathway abundance when `ko_to_kegg` is set to TRUE.
}
\examples{
\dontrun{
# Prepare the required input files and data frames
# Then, you can use the pathway_annotation function as follows:

# Use case 1: Annotating pathway information using the output file from PICRUSt2
result1 <- pathway_annotation(file = "path/to/picrust2/export/file.txt",
                              pathway = "KO",
                              daa_results_df = NULL,
                              ko_to_kegg = FALSE)

# Use case 2: Annotating pathway information from the output of pathway_daa function
# and converting KO abundance to KEGG pathway abundance
result2 <- pathway_annotation(file = NULL,
                              pathway = "KO",
                              daa_results_df = your_daa_results_df,
                              ko_to_kegg = TRUE)
}
}
