% Generated by roxygen2 (4.0.1): do not edit by hand
\name{stat_ellipse}
\alias{stat_ellipse}
\title{Plot data ellipses.}
\usage{
stat_ellipse(mapping = NULL, data = NULL, geom = "path",
  position = "identity", type = "t", level = 0.95, segments = 51,
  na.rm = FALSE, ...)
}
\arguments{
\item{level}{The confidence level at which to draw an ellipse (default is 0.95),
or, if \code{type="euclid"}, the radius of the circle to be drawn.}

\item{type}{The type of ellipse.
The default \code{"t"} assumes a multivariate t-distribution, and
\code{"norm"} assumes a multivariate normal distribution.
\code{"euclid"} draws a circle with the radius equal to \code{level},
representing the euclidian distance from the center.
This ellipse probably won't appear circular unless \code{coord_fixed()} is applied.}

\item{segments}{The number of segments to be used in drawing the ellipse.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlappling points
on this layer}

\item{...}{other arguments passed on to \code{\link{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link{layer}} for more details.}
}
\description{
Plot data ellipses.
}
\details{
The method for calculating the ellipses has been modified from car::ellipse (Fox and Weisberg, 2011)
}
\examples{
ggplot(faithful, aes(waiting, eruptions))+
  geom_point()+
  stat_ellipse()

ggplot(faithful, aes(waiting, eruptions, color = eruptions > 3))+
  geom_point()+
  stat_ellipse()

ggplot(faithful, aes(waiting, eruptions, color = eruptions > 3))+
  geom_point()+
  stat_ellipse(type = "norm", linetype = 2)+
  stat_ellipse(type = "t")

ggplot(faithful, aes(waiting, eruptions, color = eruptions > 3))+
  geom_point()+
  stat_ellipse(type = "norm", linetype = 2)+
  stat_ellipse(type = "euclid", level = 3)+
  coord_fixed()

ggplot(faithful, aes(waiting, eruptions, color = eruptions > 3))+
  stat_ellipse(geom = "polygon")
}
\references{
John Fox and Sanford Weisberg (2011). An {R} Companion to Applied Regression, Second Edition. Thousand Oaks CA: Sage. URL: http://socserv.socsci.mcmaster.ca/jfox/Books/Companion
}

