% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-gradient.r, R/zxx.r
\name{scale_colour_gradient}
\alias{scale_color_continuous}
\alias{scale_color_gradient}
\alias{scale_color_gradient2}
\alias{scale_color_gradientn}
\alias{scale_colour_continuous}
\alias{scale_colour_date}
\alias{scale_colour_datetime}
\alias{scale_colour_gradient}
\alias{scale_colour_gradient2}
\alias{scale_colour_gradientn}
\alias{scale_fill_continuous}
\alias{scale_fill_date}
\alias{scale_fill_datetime}
\alias{scale_fill_gradient}
\alias{scale_fill_gradient2}
\alias{scale_fill_gradientn}
\title{Gradient colour scales}
\usage{
scale_colour_gradient(..., low = "#132B43", high = "#56B1F7",
  space = "Lab", na.value = "grey50", guide = "colourbar")

scale_fill_gradient(..., low = "#132B43", high = "#56B1F7", space = "Lab",
  na.value = "grey50", guide = "colourbar")

scale_colour_gradient2(..., low = muted("red"), mid = "white",
  high = muted("blue"), midpoint = 0, space = "Lab",
  na.value = "grey50", guide = "colourbar")

scale_fill_gradient2(..., low = muted("red"), mid = "white",
  high = muted("blue"), midpoint = 0, space = "Lab",
  na.value = "grey50", guide = "colourbar")

scale_colour_gradientn(..., colours, values = NULL, space = "Lab",
  na.value = "grey50", guide = "colourbar", colors)

scale_fill_gradientn(..., colours, values = NULL, space = "Lab",
  na.value = "grey50", guide = "colourbar", colors)
}
\arguments{
\item{...}{Other arguments passed on to \code{\link{continuous_scale}}
to control name, limits, breaks, labels and so forth.}

\item{low, high}{Colours for low and high ends of the gradient.}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{Colour to use for missing values}

\item{guide}{Type of legend. Use \code{"colourbar"} for continuous
colour bar, or \code{"legend"} for discrete colour legend.}

\item{mid}{colour for mid point}

\item{midpoint}{The midpoint (in data value) of the diverging scale.
Defaults to 0.}

\item{colours, colors}{Vector of colours to use for n-colour gradient.}

\item{values}{if colours should not be evenly positioned along the gradient
this vector gives the position (between 0 and 1) for each colour in the
\code{colours} vector. See \code{\link{rescale}} for a convience function
to map an arbitrary range to between 0 and 1.}
}
\description{
\code{scale_*_gradient} creates a two colour gradient (low-high),
\code{scale_*_gradient2} creates a diverging colour gradient (low-mid-high),
\code{scale_*_gradientn} creats a n-colour gradient.
}
\details{
Default colours are generated with \pkg{munsell} and
\code{mnsl(c("2.5PB 2/4", "2.5PB 7/10"))}. Generally, for continuous
colour scales you want to keep hue constant, but vary chroma and
luminance. The \pkg{munsell} package makes this easy to do using the
Munsell colour system.
}
\examples{
df <- data.frame(
  x = runif(100),
  y = runif(100),
  z1 = rnorm(100),
  z2 = abs(rnorm(100))
)

# Default colour scale colours from light blue to dark blue
ggplot(df, aes(x, y)) +
  geom_point(aes(colour = z2))

# For diverging colour scales use gradient2
ggplot(df, aes(x, y)) +
  geom_point(aes(colour = z1)) +
  scale_colour_gradient2()

# Use your own colour scale with gradientn
ggplot(df, aes(x, y)) +
  geom_point(aes(colour = z1)) +
  scale_colour_gradientn(colours = terrain.colors(10))

# Equivalent fill scales do the same job for the fill aesthetic
ggplot(faithfuld, aes(waiting, eruptions)) +
  geom_raster(aes(fill = density)) +
  scale_fill_gradientn(colours = terrain.colors(10))

# Adjust colour choices with low and high
ggplot(df, aes(x, y)) +
  geom_point(aes(colour = z2)) +
  scale_colour_gradient(low = "white", high = "black")
# Avoid red-green colour contrasts because ~10\% of men have difficulty
# seeing them
}
\seealso{
\code{\link[scales]{seq_gradient_pal}} for details on underlying
  palette

Other colour scales: \code{\link{scale_alpha}},
  \code{\link{scale_colour_brewer}},
  \code{\link{scale_colour_grey}},
  \code{\link{scale_colour_hue}}
}

