% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-summary-2d.r, R/stat-summary-hex.r
\name{stat_summary_2d}
\alias{stat_summary2d}
\alias{stat_summary_2d}
\alias{stat_summary_hex}
\title{Bin and summarise in 2d (rectangle & hexagons)}
\usage{
stat_summary_2d(mapping = NULL, data = NULL, geom = "tile",
  position = "identity", ..., bins = 30, binwidth = NULL, drop = TRUE,
  fun = "mean", fun.args = list(), na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)

stat_summary_hex(mapping = NULL, data = NULL, geom = "hex",
  position = "identity", ..., bins = 30, binwidth = NULL, drop = TRUE,
  fun = "mean", fun.args = list(), na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{bins}{numeric vector giving number of bins in both vertical and
horizontal directions. Set to 30 by default.}

\item{binwidth}{Numeric vector giving bin width in both vertical and
horizontal directions. Overrides \code{bins} if both set.}

\item{drop}{drop if the output of \code{fun} is \code{NA}.}

\item{fun}{function for summary.}

\item{fun.args}{A list of extra arguments to pass to \code{fun}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}
}
\description{
\code{stat_summary_2d} is a 2d variation of \code{\link{stat_summary}}.
\code{stat_summary_hex} is a hexagonal variation of
\code{\link{stat_summary_2d}}. The data are divided into bins defined
by \code{x} and \code{y}, and then the values of \code{z} in each cell is
are summarised with \code{fun}.
}
\section{Aesthetics}{

\itemize{
 \item \code{x}: horizontal position
 \item \code{y}: vertical position
 \item \code{z}: value passed to the summary function
}
}

\section{Computed variables}{

\describe{
  \item{x,y}{Location}
  \item{value}{Value of summary statistic.}
}
}
\examples{
d <- ggplot(diamonds, aes(carat, depth, z = price))
d + stat_summary_2d()

# Specifying function
d + stat_summary_2d(fun = function(x) sum(x^2))
d + stat_summary_2d(fun = var)
d + stat_summary_2d(fun = "quantile", fun.args = list(probs = 0.1))

if (requireNamespace("hexbin")) {
d + stat_summary_hex()
}
}
\seealso{
\code{\link{stat_summary_hex}} for hexagonal summarization.
  \code{\link{stat_bin2d}} for the binning options.
}

