% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R
\docType{data}
\name{ggsf}
\alias{ggsf}
\alias{StatSf}
\alias{stat_sf}
\alias{GeomSf}
\alias{geom_sf}
\alias{CoordSf}
\alias{coord_sf}
\title{Visualise sf objects}
\usage{
stat_sf(mapping = NULL, data = NULL, geom = "rect",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)

geom_sf(mapping = aes(), data = NULL, stat = "sf",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)

coord_sf(xlim = NULL, ylim = NULL, expand = TRUE, crs = NULL,
  datum = sf::st_crs(4326), ndiscr = 100, default = FALSE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.

You can also set this to one of "polygon", "line", and "point" to
override the default legend.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{xlim}{Limits for the x and y axes.}

\item{ylim}{Limits for the x and y axes.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.}

\item{crs}{Use this to select a specific CRS. If not specified, will
use the CRS defined in the first layer.}

\item{datum}{CRS that provides datum to use when generating graticules}

\item{ndiscr}{number of segments to use for discretizing graticule lines;
try increasing this when graticules look unexpected}

\item{default}{Is this the default coordinate system? If \code{FALSE} (the default),
then replacing this coordinate system with another one creates a message alerting
the user that the coordinate system is being replaced. If \code{TRUE}, that warning
is suppressed.}
}
\description{
This set of geom, stat, and coord are used to visualise simple feature (sf)
objects. For simple plots, you will only need \code{geom_sf} as it
uses \code{stat_sf} and adds \code{coord_sf} for you. \code{geom_sf} is
an unusual geom because it will draw different geometric objects depending
on what simple features are present in the data: you can get points, lines,
or polygons.
}
\section{Geometry aesthetic}{

\code{geom_sf} uses a unique aesthetic: \code{geometry}, giving an
column of class \code{sfc} containg simple features data. There
are three ways to supply the \code{geometry} aesthetic:
\itemize{
\item Do nothing: by default \code{geom_sf} assumes it is stored in
the \code{geometry} column.
\item Explicitly pass an \code{sf} object to the \code{data} argument.
This will use the primary geometry column, no matter what it's called.
\item Supply your own using \code{aes(geometry = my_column)}
}

Unlike other aesthetics, \code{geometry} will never be inherited from
the plot.
}

\section{CRS}{

\code{coord_sf()} ensures that all layers use a common CRS. You can
either specify it using the \code{CRS} param, or \code{coord_sf} will
take it from the first layer that defines a CRS.
}

\examples{
if (requireNamespace("sf", quietly = TRUE)) {
nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
ggplot(nc) +
  geom_sf(aes(fill = AREA))

# If not supplied, coord_sf() will take the CRS from the first layer
# and automatically transform all other layers to use that CRS. This
# ensures that all data will correctly line up
nc_3857 <- sf::st_transform(nc, "+init=epsg:3857")
ggplot() +
  geom_sf(data = nc) +
  geom_sf(data = nc_3857, colour = "red", fill = NA)

# Unfortunately if you plot other types of feature you'll need to use
# show.legend to tell ggplot2 what type of legend to use
nc_3857$mid <- sf::st_centroid(nc_3857$geometry)
ggplot(nc_3857) +
  geom_sf(colour = "white") +
  geom_sf(aes(geometry = mid, size = AREA), show.legend = "point")

# You can also use layers with x and y aesthetics: these are
# assumed to already be in the common CRS.
ggplot(nc) +
  geom_sf() +
  annotate("point", x = -80, y = 35, colour = "red", size = 4)

# Thanks to the power of sf, a geom_sf nicely handles varying projections
# setting the aspect ratio correctly.
library(maps)
world1 <- sf::st_as_sf(map('world', plot = FALSE, fill = TRUE))
ggplot() + geom_sf(data = world1)

world2 <- sf::st_transform(
  world1,
  "+proj=laea +y_0=0 +lon_0=155 +lat_0=-90 +ellps=WGS84 +no_defs"
)
ggplot() + geom_sf(data = world2)
}
}
\keyword{datasets}
