% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-discrete-.r
\name{scale_x_discrete}
\alias{scale_x_discrete}
\alias{scale_y_discrete}
\title{Position scales for discrete data}
\usage{
scale_x_discrete(..., expand = waiver(), position = "bottom")

scale_y_discrete(..., expand = waiver(), position = "left")
}
\arguments{
\item{...}{Arguments passed on to \code{discrete_scale}
\describe{
  \item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
transformation object
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}
  \item{limits}{A character vector that defines possible values of the scale
and their order.}
  \item{drop}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} uses all the levels in the factor.}
  \item{na.translate}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
  \item{na.value}{If \code{na.translate = TRUE}, what value aesthetic
value should missing be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
  \item{aesthetics}{The names of the aesthetics that this scale works with}
  \item{scale_name}{The name of the scale}
  \item{palette}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the values that
they should take}
  \item{name}{The name of the scale. Used as axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
  \item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
  \item{guide}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more info.}
  \item{super}{The super class to use for the constructed scale}
}}

\item{expand}{Vector of range expansion constants used to add some
padding around the data, to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[=expand_scale]{expand_scale()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{position}{The position of the axis. \code{left} or \code{right} for y
axes, \code{top} or \code{bottom} for x axes}
}
\description{
You can use continuous positions even with a discrete position scale -
this allows you (e.g.) to place labels between bars in a bar chart.
Continuous positions are numeric values starting at one for the first
level, and increasing by one for each level (i.e. the labels are placed
at integer positions).  This is what allows jittering to work.
}
\examples{
ggplot(diamonds, aes(cut)) + geom_bar()

\donttest{
# The discrete position scale is added automatically whenever you
# have a discrete position.

(d <- ggplot(subset(diamonds, carat > 1), aes(cut, clarity)) +
      geom_jitter())

d + scale_x_discrete("Cut")
d + scale_x_discrete("Cut", labels = c("Fair" = "F","Good" = "G",
  "Very Good" = "VG","Perfect" = "P","Ideal" = "I"))

# Use limits to adjust the which levels (and in what order)
# are displayed
d + scale_x_discrete(limits = c("Fair","Ideal"))

# you can also use the short hand functions xlim and ylim
d + xlim("Fair","Ideal", "Good")
d + ylim("I1", "IF")

# See ?reorder to reorder based on the values of another variable
ggplot(mpg, aes(manufacturer, cty)) + geom_point()
ggplot(mpg, aes(reorder(manufacturer, cty), cty)) + geom_point()
ggplot(mpg, aes(reorder(manufacturer, displ), cty)) + geom_point()

# Use abbreviate as a formatter to reduce long names
ggplot(mpg, aes(reorder(manufacturer, displ), cty)) +
  geom_point() +
  scale_x_discrete(labels = abbreviate)
}
}
\seealso{
Other position scales: \code{\link{scale_x_continuous}},
  \code{\link{scale_x_date}}
}
\concept{position scales}
