% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-colorbar.R
\name{guide_colourbar}
\alias{guide_colourbar}
\alias{guide_colorbar}
\title{Continuous colour bar guide}
\usage{
guide_colourbar(
  title = waiver(),
  theme = NULL,
  nbin = NULL,
  display = "raster",
  raster = deprecated(),
  alpha = NA,
  draw.ulim = TRUE,
  draw.llim = TRUE,
  position = NULL,
  direction = NULL,
  reverse = FALSE,
  order = 0,
  available_aes = c("colour", "color", "fill"),
  ...
)

guide_colorbar(
  title = waiver(),
  theme = NULL,
  nbin = NULL,
  display = "raster",
  raster = deprecated(),
  alpha = NA,
  draw.ulim = TRUE,
  draw.llim = TRUE,
  position = NULL,
  direction = NULL,
  reverse = FALSE,
  order = 0,
  available_aes = c("colour", "color", "fill"),
  ...
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[=waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[=labs]{labs()}} is used for the title.}

\item{theme}{A \code{\link[=theme]{theme}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides, and is combined with, the plot's theme.}

\item{nbin}{A numeric specifying the number of bins for drawing the
colourbar. A smoother colourbar results from a larger value.}

\item{display}{A string indicating a method to display the colourbar. Can be
one of the following:
\itemize{
\item \code{"raster"} to display as a bitmap image.
\item \code{"rectangles"} to display as a series of rectangles.
\item \code{"gradient"} to display as a linear gradient.
}

Note that not all devices are able to render rasters and gradients.}

\item{raster}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}  A logical. If \code{TRUE} then
the colourbar is rendered as a raster object. If \code{FALSE} then the colourbar
is rendered as a set of rectangles. Note that not all graphics devices are
capable of rendering raster image.}

\item{alpha}{A numeric between 0 and 1 setting the colour transparency of
the bar. Use \code{NA} to preserve the alpha encoded in the colour itself
(default).}

\item{draw.ulim}{A logical specifying if the upper limit tick marks should
be visible.}

\item{draw.llim}{A logical specifying if the lower limit tick marks should
be visible.}

\item{position}{A character string indicating where the legend should be
placed relative to the plot panels.}

\item{direction}{A character string indicating the direction of the guide.
One of "horizontal" or "vertical."}

\item{reverse}{logical. If \code{TRUE} the colourbar is reversed. By default,
the highest value is on the top and the lowest value is on the bottom}

\item{order}{positive integer less than 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}

\item{available_aes}{A vector of character strings listing the aesthetics
for which a colourbar can be drawn.}

\item{...}{ignored.}
}
\value{
A guide object
}
\description{
Colour bar guide shows continuous colour scales mapped onto values.
Colour bar is available with \code{scale_fill} and \code{scale_colour}.
For more information, see the inspiration for this function:
\href{http://www.mathworks.com/help/techdoc/ref/colorbar.html}{Matlab's colorbar function}.
}
\details{
Guides can be specified in each \verb{scale_*} or in \code{\link[=guides]{guides()}}.
\code{guide="legend"} in \verb{scale_*} is syntactic sugar for
\code{guide=guide_legend()} (e.g. \code{scale_colour_manual(guide = "legend")}).
As for how to specify the guide for each scale in more detail,
see \code{\link[=guides]{guides()}}.
}
\examples{
df <- expand.grid(X1 = 1:10, X2 = 1:10)
df$value <- df$X1 * df$X2

p1 <- ggplot(df, aes(X1, X2)) + geom_tile(aes(fill = value))
p2 <- p1 + geom_point(aes(size = value))

# Basic form
p1 + scale_fill_continuous(guide = "colourbar")
p1 + scale_fill_continuous(guide = guide_colourbar())
p1 + guides(fill = guide_colourbar())

# Control styles

# bar size
p1 + guides(fill = guide_colourbar(theme = theme(
  legend.key.width  = unit(0.5, "lines"),
  legend.key.height = unit(10, "lines")
)))


# no label
p1 + guides(fill = guide_colourbar(theme = theme(
  legend.text = element_blank()
)))

# no tick marks
p1 + guides(fill = guide_colourbar(theme = theme(
  legend.ticks = element_blank()
)))

# label position
p1 + guides(fill = guide_colourbar(theme = theme(
  legend.text.position = "left"
)))

# label theme
p1 + guides(fill = guide_colourbar(theme = theme(
  legend.text = element_text(colour = "blue", angle = 0)
)))

# small number of bins
p1 + guides(fill = guide_colourbar(nbin = 3))

# large number of bins
p1 + guides(fill = guide_colourbar(nbin = 100))

# make top- and bottom-most ticks invisible
p1 +
  scale_fill_continuous(
    limits = c(0,20), breaks = c(0, 5, 10, 15, 20),
    guide = guide_colourbar(nbin = 100, draw.ulim = FALSE, draw.llim = FALSE)
  )

# guides can be controlled independently
p2 +
  scale_fill_continuous(guide = "colourbar") +
  scale_size(guide = "legend")
p2 + guides(fill = "colourbar", size = "legend")

p2 +
  scale_fill_continuous(guide = guide_colourbar(theme = theme(
    legend.direction = "horizontal"
  ))) +
  scale_size(guide = guide_legend(theme = theme(
    legend.direction = "vertical"
  )))
}
\seealso{
Other guides: 
\code{\link{guide_bins}()},
\code{\link{guide_coloursteps}()},
\code{\link{guide_legend}()},
\code{\link{guides}()}
}
\concept{guides}
