% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-label-linked.r, R/geom-text-linked.r
\name{geom_label_s}
\alias{geom_label_s}
\alias{geom_text_s}
\title{Linked Text}
\usage{
geom_label_s(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  label.padding = grid::unit(0.25, "lines"),
  label.r = grid::unit(0.15, "lines"),
  label.size = 0.25,
  add.segments = TRUE,
  box.padding = 0.25,
  point.padding = 1e-06,
  min.segment.length = 0,
  arrow = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_text_s(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  add.segments = TRUE,
  box.padding = 0.25,
  point.padding = 1e-06,
  min.segment.length = 0,
  arrow = NULL,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by
\code{\link[ggplot2]{aes}}. If specified and with \code{inherit.aes = TRUE}
(the default), it is combined with the default mapping at the top level of
the plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There
  are three types of arguments you can use here:

  \itemize{ \item Aesthetics: to set an aesthetic to a fixed value, like
  \code{colour = "red"} or \code{size = 3}. \item Other arguments to the
  layer, for example you override the default \code{stat} associated with the
  layer. \item Other arguments passed on to the stat. }}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustments to nudge the
starting position of each text label. The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}

\item{label.padding}{Amount of padding around label. Defaults to 0.25 lines.}

\item{label.r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{label.size}{Size of label border, in mm.}

\item{add.segments}{logical Display connecting segments or arrows between
original positions and displaced ones if both are available.}

\item{box.padding, point.padding}{numeric By how much each end of the segments
should shortened.}

\item{min.segment.length}{numeric Segments shorter that the minimum length
are not rendered. (implemented only for \code{geom_text_s()})}

\item{arrow}{specification for arrow heads, as created by
\code{\link[grid]{arrow}}}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes a legend if any aesthetics are mapped.
\code{FALSE} never includes it, and \code{TRUE} always includes it.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g., \code{\link[ggplot2]{borders}}.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} takes place at draw
time and in the order of the data, thus its action depends of the size at
which the plot is drawn.}
}
\value{
A plot layer instance.
}
\description{
Text geoms are most useful for labelling plots. `geom_text_s()`
  and `geom_label_s()` add text to the plot and for nudged positions link the
  original location to the nudged text with a segment.
}
\details{
Geometries \code{geom_text_s()} and \code{geom_label_s()} have an interface
  that follows closely that of \code{geom_text_repel()} and \code{geom_label_repel()}.
  At the current stage of development even if formal parameters have the same
  names, arguments with the same numeric value may have quantitatively
  different effects on the resulting plot.

  These geometries use by default \code{\link{position_nudge_keep}}
  which is backwards compatible with \code{\link[ggplot2]{position_nudge}}.
  In contrast to \code{\link[ggplot2]{position_nudge}},
  \code{\link{position_nudge_keep}} and all other position functions defined
  in packages 'ggpp' and 'ggrepel' keep the original coordinates, thus
  allowing the plotting of connecting segments and arrows.

  Note that when you change the scale limits for \emph{x} and/or \emph{y} of
  a plot, text labels stay the same size, as determined by the \code{size}
  aesthetic. The actual size as seen in the plotted output is decided during
  the rendering of the plot to a graphics device. Limits are expanded only to
  include the anchor point of the labels because the "width" and "height" of
  a text element are 0 (as seen by ggplot2). For the same reason, stacking
  and dodging text will not work as they take place within 'ggplot2' before
  the rendered size of text is known. Text labels do have height and width,
  but in grid units, not data units.
}
\section{Under development}{
 Aesthetic \code{segment.linetype} is not yet
  implemented. The rendered plot may still slightly change slightly in
  future versions. In particular justification based on the position
  displacement needs some improvement.
}

\section{Alignment}{
 You can modify text alignment with the \code{vjust} and
  \code{hjust} aesthetics. These can either be a number between 0
  (right/bottom) and 1 (top/left) or a character (\code{"left"},
  \code{"middle"}, \code{"right"}, \code{"bottom"}, \code{"center"},
  \code{"top"}). In addition, you can use special alignments for
  justification including \code{"position"}, \code{"inward"} and
  \code{"outward"}. Inward always aligns text towards the center of the
  plotting area, and outward aligns it away from the center of the plotting
  area. If tagged with \code{_mean} or \code{_median} (e.g.,
  \code{"outward_mean"}) the mean or median of the data in the panel along
  the corresponding axis is used as center. If the characters following the
  underscore represent a number (e.g., \code{"outward_10.5"}) the reference
  point will be this value in data units. Position justification is computed
  based on the direction of the displacement of the position of the label so
  that each individual text or label is justified outwards from its original
  position. The default justification is \code{"position"}.

  If nudging is at its default of zero, or a position function defined in
  'ggplot2' is used, these geometries behave like the corresponding
  ones from package 'ggplot2' with a default justification of \code{0.5} and
  no segment drawn.
}

\examples{

my.cars <- mtcars[c(TRUE, FALSE, FALSE, FALSE), ]
my.cars$name <- rownames(my.cars)
p <- ggplot(my.cars, aes(wt, mpg, label = name)) +
       geom_point(color = "red")

# Use nudging
p +
  geom_text_s(nudge_x = 0.12) +
  expand_limits(x = 6.2)
p +
  geom_text_s(nudge_x = 0.12,
              arrow = arrow(length = grid::unit(1.5, "mm"))) +
  expand_limits(x = 6.2)
p +
  geom_text_s(hjust = "left", nudge_x = 0.12) +
  expand_limits(x = 6.2)
p +
  geom_text_s(nudge_y = 0.1, nudge_x = 0.07) +
  expand_limits(x = 6.2)
p +
  geom_text_s(nudge_y = 0.25, angle = 90) +
  expand_limits(y = 30)
p +
  geom_text_s(nudge_y = 0.22) +
  expand_limits(x = c(2, 6))
p +
  geom_text_s(angle = 90, nudge_y = 1,
              arrow = arrow(length = grid::unit(1.5, "mm")),
              segment.colour = "red") +
  expand_limits(y = 30)

p +
  geom_label_s(nudge_x = 0.12) +
  expand_limits(x = 6.2)

p +
  geom_label_s(hjust = "outward_1", nudge_x = 0.12) +
  expand_limits(x = 6.2)

p +
  geom_label_s(hjust = "inward_3", nudge_y = 0.4)

p +
  geom_label_s(nudge_x = 0.1) +
  expand_limits(x = 6.2)

p +
  geom_label_s(nudge_x = -0.1) +
  expand_limits(x = 1.5)

# Add aesthetic mappings and adjust arrows
p +
  geom_text_s(aes(colour = factor(cyl)),
              segment.colour = "black",
              angle = 90,
              nudge_y = 1,
              arrow = arrow(angle = 20,
                            length = grid::unit(1.5, "mm"),
                            ends = "first",
                            type = "closed"),
              show.legend = FALSE) +
  scale_colour_discrete(l = 40) + # luminance, make colours darker
  expand_limits(y = 25)

# Add aesthetic mappings and adjust arrows
p +
  geom_label_s(aes(colour = factor(cyl)),
              nudge_x = 0.3,
              arrow = arrow(angle = 20,
                            length = grid::unit(1/3, "lines"))) +
  scale_colour_discrete(l = 40) + # luminance, make colours darker
  expand_limits(x = 7)

# Scale height of text, rather than sqrt(height)
p +
  geom_text_s(aes(size = wt), nudge_x = -0.1) +
  scale_radius(range = c(3,6)) + # override scale_area()
    expand_limits(x = c(1.8, 5.5))

}
