% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connections.R
\name{get_con}
\alias{get_con}
\alias{gCon}
\title{Create a connection extractor function}
\usage{
get_con(from = integer(), to = integer(), paths = NULL, ...)
}
\arguments{
\item{from, to}{The index of the start and end nodes for the connections}

\item{paths}{A list of integer vectors giving the index of nodes defining
connections}

\item{...}{Additional information to be added to the final data output}
}
\value{
A function that takes a layout_ggraph object and returns the given
connections
}
\description{
Connections within the ggraph terminology are links between nodes that are
not part of the network structure itself. In that sense connections does not
affect the layout calculation in any way and will not be drawn by the
standard \code{geom_edge_*} functions. A connection does not need to only be
defined by a start and end node, but can include intermediary nodes.
\code{get_con} helps in creating connection data by letting you specify start
and end node and automatically find the shortest path within the graph
structure that connects the given points. If this is not what is needed it is
also possible to supply a list of vectors giving node indexes that defines a
connection.
}
\seealso{
Other extractors: \code{\link{get_edges}},
  \code{\link{get_nodes}}
}
