% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_node_arc_bar.R
\name{geom_node_arc_bar}
\alias{geom_node_arc_bar}
\title{Show nodes as circles}
\usage{
geom_node_arc_bar(mapping = NULL, data = NULL, position = "identity",
  show.legend = NA, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}}
or \code{\link[ggplot2]{aes_}}. By default x and y are mapped to x0 and y0 in
the node data.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There
are three types of arguments you can use here:
\itemize{
 \item{Aesthetics: to set an aesthetic to a fixed value, like
 \code{color = "red"} or \code{size = 3.}}
 \item{Other arguments to the layer, for example you override the default
 \code{stat} associated with the layer.}
 \item{Other arguments passed on to the stat.}
}}
}
\description{
This geom is equivalent in functionality to \code{\link[ggforce]{geom_circle}}
and allows for plotting of nodes as circles with a radius scaled by the
coordinate system. Beceause of the geoms reliance on the coordinate system
it will only produce true circles when combined with
\code{\link[ggplot2]{coord_fixed}}
}
\section{Aesthetics}{

geom_node_point understand the following aesthetics. Bold aesthetics are
automatically set, but can be overridden.
\itemize{
 \item{\strong{x0}}
 \item{\strong{y0}}
 \item{\strong{r}}
 \item{alpha}
 \item{colour}
 \item{fill}
 \item{shape}
 \item{size}
 \item{stroke}
 \item{filter}
}
}

\examples{
require(igraph)
gr <- graph_from_data_frame(flare$edges, vertices = flare$vertices)
ggraph(gr, 'circlepack', weight = 'size') + geom_node_circle() + coord_fixed()

}
\seealso{
Other geom_node_*: \code{\link{geom_node_circle}},
  \code{\link{geom_node_point}},
  \code{\link{geom_node_text}},
  \code{\link{geom_node_tile}}
}
\author{
Thomas Lin Pedersen
}
