% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_igraph.R
\name{layout_igraph_linear}
\alias{layout_igraph_linear}
\title{Place nodes on a line or circle}
\usage{
layout_igraph_linear(graph, circular, sort.by = NULL, use.numeric = FALSE,
  offset = pi/2)
}
\arguments{
\item{graph}{An igraph object}

\item{circular}{Logical. Should the layout be transformed to a circular
representation. Defaults to \code{FALSE}.}

\item{sort.by}{The name of a vertex attribute to sort the nodes by.}

\item{use.numeric}{Logical. Should a numeric sort.by attribute be used as the
actual x-coordinates in the layout. May lead to overlapping nodes. Defaults
to FALSE}

\item{offset}{If \code{circular = TRUE}, where should it begin. Defaults to
\code{pi/2} which is equivalent to 12 o'clock.}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{circular} as
well as any information stored as vertex attributes on the igraph object.
}
\description{
This layout puts all nodes on a line, possibly sorted by a node attribute. If
\code{circular = TRUE} the nodes will be laid out on the unit circle instead.
In the case where the \code{sort.by} attribute is numeric, the numeric values
will be used as the x-position and it is thus possible to have uneven spacing
between the nodes.
}
\seealso{
Other layout_igraph_*: \code{\link{layout_igraph_auto}},
  \code{\link{layout_igraph_circlepack}},
  \code{\link{layout_igraph_dendrogram}},
  \code{\link{layout_igraph_hive}},
  \code{\link{layout_igraph_manual}},
  \code{\link{layout_igraph_partition}},
  \code{\link{layout_igraph_treemap}}
}
