% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_edge_density.R
\name{geom_edge_density}
\alias{geom_edge_density}
\title{Show edges as a density map}
\usage{
geom_edge_density(mapping = NULL, data = get_edges("short"),
  position = "identity", show.legend = NA, n = 100, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}
or \code{\link[ggplot2:aes_]{ggplot2::aes_()}}. By default x, y, xend, yend, group and
circular are mapped to x, y, xend, yend, edge.id and circular in the edge
data.}

\item{data}{The return of a call to \code{get_edges()} or a data.frame
giving edges in correct format (see details for for guidance on the format).
See \code{\link[=get_edges]{get_edges()}} for more details on edge extraction.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{n}{The number of points to estimate in the x and y direction, i.e. the
resolution of the raster.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
This geom makes it possible to add a layer showing edge presence as a density
map. Each edge is converted to \code{n} points along the line and a jitter is
applied. Based on this dataset a two-dimensional kernel density estimation is
applied and plotted as a raster image. The density is mapped to the alpha
level, making it possible to map a variable to the fill.
}
\section{Aesthetics}{

\code{geom_edge_density} understand the following aesthetics. Bold aesthetics are
automatically set, but can be overridden.

\strong{x}
\strong{y}
\strong{xend}
\strong{yend}
edge_fill
filter
}

\section{Computed variables}{


\describe{
\item{x, y}{The coordinates for each pixel in the raster}
\item{density}{The density associated with the pixel}
}
}

\section{Edge aesthetic name expansion}{

In order to avoid excessive typing edge aesthetic names are
automatically expanded. Because of this it is not necessary to write
\code{edge_colour} within the \code{aes()} call as \code{colour} will
automatically be renamed appropriately.
}

\examples{
require(tidygraph)
gr <- create_notable('bull') \%>\%
  activate(edges) \%>\%
  mutate(class = sample(letters[1:3], n(), replace = TRUE))

ggraph(gr, 'stress') +
  geom_edge_density(aes(fill = class)) +
  geom_edge_link() + geom_node_point()
}
\seealso{
Other geom_edge_*: \code{\link{geom_edge_arc}},
  \code{\link{geom_edge_bend}},
  \code{\link{geom_edge_diagonal}},
  \code{\link{geom_edge_elbow}},
  \code{\link{geom_edge_fan}},
  \code{\link{geom_edge_hive}},
  \code{\link{geom_edge_link}},
  \code{\link{geom_edge_loop}},
  \code{\link{geom_edge_parallel}},
  \code{\link{geom_edge_point}},
  \code{\link{geom_edge_span}},
  \code{\link{geom_edge_tile}}
}
\author{
Thomas Lin Pedersen
}
\concept{geom_edge_*}
