% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_dendrogram.R
\name{layout_tbl_graph_dendrogram}
\alias{layout_tbl_graph_dendrogram}
\title{Apply a dendrogram layout to layout_tbl_graph}
\usage{
layout_tbl_graph_dendrogram(
  graph,
  circular = FALSE,
  offset = pi/2,
  height = NULL,
  length = NULL,
  repel = FALSE,
  ratio = 1,
  direction = "out"
)
}
\arguments{
\item{graph}{A \code{tbl_graph} object}

\item{circular}{Logical. Should the layout be transformed to a circular
representation. Defaults to \code{FALSE}.}

\item{offset}{If \code{circular = TRUE}, where should it begin. Defaults to
\code{pi/2} which is equivalent to 12 o'clock.}

\item{height}{The node variable holding the height of each node in the
dendrogram. If \code{NULL} it will be calculated as the maximal distance to a
leaf.}

\item{length}{An edge parameter giving the length of each edge. The node
height will be calculated from the maximal length to the root node (ignored
if \code{height} does not evaluate to \code{NULL})}

\item{repel}{Should leafs repel each other relative to the height of their
common ancestor. Will emphasize clusters}

\item{ratio}{The strength of repulsion if \code{repel = TRUE}. Higher values will
give more defined clusters}

\item{direction}{The direction to the leaves. Defaults to 'out'}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{circular}, \code{depth} and
\code{leaf} as well as any information stored as node variables on the
tbl_graph
}
\description{
This layout mimics the \code{\link[igraph:layout_as_tree]{igraph::layout_as_tree()}} algorithm
supplied by igraph, but puts all leaves at 0 and builds it up from there,
instead of starting from the root and building it from there. The height of
branch points are related to the maximum distance to an edge from the branch
node, or read from a node variable.
}
\note{
This function is not intended to be used directly but by setting
\code{layout = 'dendrogram'} in \code{\link[=create_layout]{create_layout()}}
}
\seealso{
Other layout_tbl_graph_*: 
\code{\link{layout_tbl_graph_auto}()},
\code{\link{layout_tbl_graph_backbone}()},
\code{\link{layout_tbl_graph_centrality}()},
\code{\link{layout_tbl_graph_circlepack}()},
\code{\link{layout_tbl_graph_eigen}()},
\code{\link{layout_tbl_graph_fabric}()},
\code{\link{layout_tbl_graph_focus}()},
\code{\link{layout_tbl_graph_hive}()},
\code{\link{layout_tbl_graph_igraph}()},
\code{\link{layout_tbl_graph_linear}()},
\code{\link{layout_tbl_graph_manual}()},
\code{\link{layout_tbl_graph_matrix}()},
\code{\link{layout_tbl_graph_partition}()},
\code{\link{layout_tbl_graph_pmds}()},
\code{\link{layout_tbl_graph_stress}()},
\code{\link{layout_tbl_graph_treemap}()},
\code{\link{layout_tbl_graph_unrooted}()}
}
\concept{layout_tbl_graph_*}
