% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reveal_save.R
\name{reveal_save}
\alias{reveal_save}
\title{Saves incremental plots}
\usage{
reveal_save(plot_list, basename, ...)
}
\arguments{
\item{plot_list}{A list of plots created by one of the \verb{reveal_*} functions (e.g. \code{\link[=reveal_groups]{reveal_groups()}}, \code{\link[=reveal_layers]{reveal_layers()}}, \code{\link[=reveal_aes]{reveal_aes()}}]}

\item{basename}{The base file name that will be used for saving.}

\item{...}{Additional arguments (e.g. width, height) to be passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}}
}
\value{
The paths of the saved plots, invisibly
}
\description{
Saves incremental plots
}
\examples{
# Create full plot
library(ggplot2)
data("mtcars")

p <- mtcars |>
  ggplot(aes(mpg, wt,
             color = factor(vs),
             group = factor(vs))) +
  geom_point() +
  geom_smooth(method="lm",
              formula = 'y ~ x',
              linewidth=1) +
  facet_wrap(~am)
p

plot_list <- reveal_groups(p)
plot_list[[1]]
plot_list[[2]]
plot_list[[3]]

# Save plots
reveal_save(plot_list, "myplot.png", width = 8, height = 4, path = tempdir())

# Clean temp files
file.remove(list.files(path = tempdir(), pattern = "myplot", full.names = TRUE)) 
}
