% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat.R
\name{SectorPlot}
\alias{SectorPlot}
\title{Draw sector for seurat object}
\usage{
SectorPlot(
  object,
  features,
  features.level,
  assay,
  slot = c("data", "scale.data", "counts"),
  group.by,
  group.level,
  split.by,
  split.level,
  col_low = "blue",
  col_mid = "white",
  col_high = "red",
  col_midpoint,
  ...
)
}
\arguments{
\item{object}{Seurat object}

\item{features}{Input vector of genes list.}

\item{features.level}{Levels of genes list.}

\item{assay}{Specific assay to get data from or set data for; defaults to the default assay.}

\item{slot}{Specific assay data to get or set.}

\item{group.by}{Column of metadata to group the cells by, default is Idents().}

\item{group.level}{Levels of group.}

\item{split.by}{Column of metadata to split the cells by, default is NULL.}

\item{split.level}{Levels of split vars.}

\item{col_low}{Colours for low ends of the gradient.}

\item{col_mid}{Colour for mid point.}

\item{col_high}{Colours for high ends of the gradient.}

\item{col_midpoint}{The midpoint (in data value) of the diverging scale.}

\item{...}{Other arguments for \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}.
Defaults to quantile(exp, 0.5)}
}
\value{
ggplot
}
\description{
A better alternative to \code{\link[Seurat:DotPlot]{Seurat::DotPlot()}}.
For more details, please type \code{vignette("ggsector")}.
}
\examples{
\donttest{
## Download pbmc data from
# https://cf.10xgenomics.com/samples/cell/pbmc3k/pbmc3k_filtered_gene_bc_matrices.tar.gz
library(Seurat)
path <- paste0(tempdir(), "/pbmc3k.tar.gz")
file <- paste0(tempdir(), "/filtered_gene_bc_matrices/hg19")
download.file(
    "https://cf.10xgenomics.com/samples/cell/pbmc3k/pbmc3k_filtered_gene_bc_matrices.tar.gz",
    path
)
untar(path, exdir = tempdir())
pbmc.data <- Read10X(data.dir = file)
pbmc <- CreateSeuratObject(
    counts = pbmc.data,
    project = "pbmc3k",
    min.cells = 3,
    min.features = 200
)
pbmc <- NormalizeData(pbmc)
pbmc <- FindVariableFeatures(pbmc, selection.method = "vst", nfeatures = 2000)
pbmc <- ScaleData(pbmc, features = rownames(pbmc))
pbmc <- RunPCA(pbmc)
pbmc <- RunUMAP(pbmc, dim = 1:10)
pbmc <- FindNeighbors(pbmc, dims = 1:10)
pbmc <- FindClusters(pbmc, resolution = 1)
pbmc <- FindClusters(pbmc, resolution = 0.5)
markers <- tibble::tribble(
    ~type, ~marker,
    "Naive CD4+ T", "IL7R,CCR7",
    "CD14+ Mono", "CD14,LYZ",
    "Memory CD4+", "IL7R,S100A4",
    "B", "MS4A1",
    "CD8+ T", "CD8A",
    "FCGR3A+ Mono", "FCGR3A,MS4A7",
    "NK", "GNLY,NKG7",
    "DC", "FCER1A,CST3",
    "Platelet", "PPBP",
) \%>\%
    tidyr::separate_rows(marker, sep = ", *") \%>\%
    dplyr::distinct()

# Dotplot
DotPlot(pbmc, features = unique(markers$marker)) + coord_flip()

# contrast with DotPlot
SectorPlot(pbmc, markers$marker, features.level = unique(rev(markers$marker)))

SectorPlot(pbmc, markers$marker, group.by = "RNA_snn_res.1")

# split plot
# Assume a variable 'day', expressed as the number of days of cell development.
set.seed(1)
pbmc[["day"]] <- sample(1:3, ncol(pbmc), TRUE)
SectorPlot(pbmc, markers$marker, group.by = "RNA_snn_res.0.5", split.by = "day")
SectorPlot(
    pbmc, markers$marker,
    group.by = "day", split.by = "RNA_snn_res.0.5", nrow = 1
)
}

}
