% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_freesurfer.R
\name{read_atlas_files}
\alias{read_atlas_files}
\title{Read in atlas data from all subjects}
\usage{
read_atlas_files(subjects_dir, atlas)
}
\arguments{
\item{subjects_dir}{Freesurfer subject directory}

\item{atlas}{unique character combination identifying the atlas}
}
\value{
tibble with stats information for subjects from FreeSurfer
}
\description{
Recursively reads in all stats files for
an atlas (given a unique character string),
for all subjects in the subjects directory.
Will add hemisphere and subject id to the data.
}
\examples{
\dontrun{
subj_dir <- freesurfer::fs_subj_dir()
read_atlas_files(subj_dir, "aseg.stats")

read_atlas_files(subj_dir, "lh.aparc.stats")
}
}
