% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-spatial.R
\name{stat_spatial_identity}
\alias{stat_spatial_identity}
\alias{geom_spatial_point}
\alias{geom_spatial_path}
\alias{geom_spatial_polygon}
\alias{geom_spatial_text}
\alias{geom_spatial_label}
\alias{geom_spatial_text_repel}
\alias{geom_spatial_label_repel}
\title{Spatial-aware ggplot2 layers}
\usage{
stat_spatial_identity(
  mapping = NULL,
  data = NULL,
  crs = NULL,
  geom = "point",
  position = "identity",
  ...,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_spatial_point(mapping = NULL, data = NULL, crs = NULL, ...)

geom_spatial_path(mapping = NULL, data = NULL, crs = NULL, ...)

geom_spatial_polygon(mapping = NULL, data = NULL, crs = NULL, ...)

geom_spatial_text(mapping = NULL, data = NULL, crs = NULL, ...)

geom_spatial_label(mapping = NULL, data = NULL, crs = NULL, ...)

geom_spatial_text_repel(mapping = NULL, data = NULL, crs = NULL, ...)

geom_spatial_label_repel(mapping = NULL, data = NULL, crs = NULL, ...)
}
\arguments{
\item{mapping}{An aesthetic mapping created with \code{\link[ggplot2:aes]{ggplot2::aes()}}.}

\item{data}{A data frame or other object, coerced to a data.frame by \code{\link[ggplot2:fortify]{ggplot2::fortify()}}.}

\item{crs}{The crs of the x and y aesthetics, or NULL to use default lon/lat
crs (with a message).}

\item{geom}{The geometry to use.}

\item{position}{The position to use.}

\item{...}{Passed to the combined stat/geom as parameters or fixed aesthetics.}

\item{show.legend, inherit.aes}{See \code{\link[ggplot2:layer]{ggplot2::layer()}}.}
}
\value{
A \code{\link[ggplot2:layer]{ggplot2::layer()}}.
}
\description{
These layers are much like their counterparts, \link[ggplot2:stat_identity]{stat_identity},
\link[ggplot2:geom_point]{geom_point}, \link[ggplot2:geom_path]{geom_path},
and \link[ggplot2:geom_polygon]{geom_polygon}, except they have a \code{crs} argument that
ensures they are projected when using \link[ggplot2:coord_sf]{coord_sf}. Stats are applied to the x and y coordinates
that have been transformed.
}
\examples{
cities <- data.frame(
  x = c(-63.58595, 116.41214, 0),
  y = c(44.64862, 40.19063, 89.9),
  city = c("Halifax", "Beijing", "North Pole")
)

library(ggrepel)
ggplot(cities, aes(x, y)) +
  geom_spatial_point(crs = 4326) +
  stat_spatial_identity(aes(label = city), geom = "label_repel") +
  coord_sf(crs = 3857)

}
