% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-spatial-segment.R
\docType{data}
\name{geom_spatial_segment}
\alias{geom_spatial_segment}
\alias{StatSpatialSegment}
\title{Spatial line segments}
\format{
An object of class \code{StatSpatialSegment} (inherits from \code{StatSpatialRect}, \code{Stat}, \code{ggproto}, \code{gg}) of length 3.
}
\usage{
geom_spatial_segment(
  mapping = NULL,
  data = NULL,
  ...,
  crs = NULL,
  detail = waiver(),
  great_circle = TRUE,
  wrap_dateline = TRUE,
  arrow = NULL,
  lineend = "butt",
  linejoin = "round",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

StatSpatialSegment
}
\arguments{
\item{mapping}{An aesthetic mapping created with \code{\link[ggplot2:aes]{ggplot2::aes()}}.}

\item{data}{A data frame or other object, coerced to a data.frame by \code{\link[ggplot2:fortify]{ggplot2::fortify()}}.}

\item{...}{Passed to the combined stat/geom as parameters or fixed aesthetics.}

\item{crs}{The crs of the x and y aesthetics, or NULL to use default lon/lat
crs (with a message).}

\item{detail}{Passed to \code{\link[sf:geos_unary]{sf::st_segmentize()}}: the number of line segments
per quadrant of the bounding box. Increase this number for a smoother
projected bounding box.}

\item{great_circle}{If \code{TRUE}, use \code{\link[lwgeom:geod]{lwgeom::st_geod_segmentize()}}
to connect the (x, y) and (xend, yend) with the shortest possible
great circle along the earth.}

\item{wrap_dateline}{When using \code{great_circle = TRUE}, using
\code{wrap_dateline = TRUE} splits the great circle along the dateline.
You may want to pass \code{FALSE} here if using \code{arrow} and a projection
that wraps the dateline.}

\item{arrow}{An arrow specification as a call to \code{\link[grid:arrow]{grid::arrow()}}.}

\item{lineend}{See \code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}}.}

\item{linejoin}{How corners should be joined}

\item{na.rm}{Should missing aesthetic values be removed?}

\item{show.legend}{See \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{inherit.aes}{See \code{\link[ggplot2:layer]{ggplot2::layer()}}.}
}
\description{
While the implementation is slightly differrent, this function is
intended to behave identically to \code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}}. Use
\code{great_circle = FALSE} and \code{detail = NULL} if you wish ignore the fact
that the earth is round.
}
\examples{
library(ggplot2)

# visualize flights from
# Halifax -> Anchorage -> Berlin -> Halifax
cities <- data.frame(
  lon = c(-63.58595, 116.41214, 13.50, -149.75),
  lat = c(44.64862, 40.19063, 52.51, 61.20),
  city = c("Halifax", "Beijing", "Berlin", "Anchorage"),
  city_to = c("Anchorage", "Beijing", "Berlin", "Halifax")
)

cities$lon_end <- cities$lon[c(4, 3, 1, 2)]
cities$lat_end <- cities$lat[c(4, 3, 1, 2)]

p <- ggplot(cities, aes(lon, lat, xend = lon_end, yend = lat_end)) +
  geom_spatial_point(crs = 4326)

# by default, geom_spatial_segment() connects points
# using the shortest distance along the face of the earth
# wrapping at the date line
p +
  geom_spatial_segment(crs = 4326) +
  coord_sf(crs = 3857)

# to let the projection handle the dateline,
# use `wrap_dateline = FALSE` (most useful for
# when using `arrow`)
p +
  geom_spatial_segment(
    wrap_dateline = FALSE,
    arrow = grid::arrow(),
    crs = 4326
  ) +
  coord_sf(crs = 3995)

# to ignore the roundness of the earth, use
# `great_circle = FALSE`
p +
  geom_spatial_segment(
    great_circle = FALSE,
    arrow = grid::arrow(),
    crs = 4326
  ) +
  coord_sf(crs = 3995)

}
\keyword{datasets}
