% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-filter-spct.r
\name{plot.filter_spct}
\alias{plot.filter_spct}
\title{Plot method for filter spectra.}
\usage{
\method{plot}{filter_spct}(x, ...,
  w.band = getOption("photobiology.plot.bands", default = list(UVC(), UVB(),
  UVA(), PAR())), range = NULL,
  plot.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  pc.out = FALSE, label.qty = NULL,
  annotations = getOption("photobiology.plot.annotations", default =
  c("boxes", "labels", "summaries", "colour.guide", "peaks")),
  text.size = 2.5, na.rm = TRUE)
}
\arguments{
\item{x}{a filter_spct object}

\item{...}{other arguments passed along, such as \code{label.qty}}

\item{w.band}{a single waveband object or a list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{plot.qty}{character string one of "transmittance" or "absorbance"}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one}

\item{label.qty}{character string giving the type of summary quantity to use
for labels}

\item{annotations}{a character vector}

\item{text.size}{numeric size of text in the plot decorations.}

\item{na.rm}{logical.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a filter_spct
object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot objects, and can be further manipulated.
}
\examples{
library(photobiology)
plot(yellow_gel.spct)
plot(yellow_gel.spct, pc.out = TRUE)

plot(polyester.spct)
plot(polyester.spct, plot.qty = "absorbance")

}
\seealso{
Other plot functions: \code{\link{plot.cps_spct}},
  \code{\link{plot.object_spct}},
  \code{\link{plot.raw_spct}},
  \code{\link{plot.reflector_spct}},
  \code{\link{plot.response_spct}},
  \code{\link{plot.source_spct}},
  \code{\link{plot.waveband}}
}
\keyword{hplot}

