% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-wb-irrad.R
\name{stat_wb_irrad}
\alias{stat_wb_irrad}
\title{Integrate irradiance for wavebands.}
\usage{
stat_wb_irrad(mapping = NULL, data = NULL, geom = "text", w.band = NULL,
  time.unit, unit.in, label.qty = "total", label.mult = 1,
  label.fmt = "\%.3g", ypos.mult = 1.07, ypos.fixed = NULL,
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_string}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{w.band}{a waveband object or a list of waveband objects or numeric
vector of at least length two.}

\item{time.unit}{character or lubridate::duration}

\item{unit.in}{character One of "photon","quantum" or "energy"}

\item{label.qty}{character}

\item{label.mult}{numeric Scaling factor applied to y-integral values before
conversion into character strings.}

\item{label.fmt}{character string giving a format definition for converting
y-integral values into character strings by means of function
\code{\link{sprintf}}.}

\item{ypos.mult}{numeric Multiplier constant used to scale returned
\code{y} values.}

\item{ypos.fixed}{numeric If not \code{NULL} used a constant value returned
in \code{y}.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_wb_irrad} computes areas under a curve.
}
\section{Computed variables}{

\describe{
  \item{y.label}{integral value as formatted text}
  \item{x}{w.band-midpoint}
  \item{xmin}{w.band minimum}
  \item{xmax}{w.band maximum}
  \item{ymin}{data$y minimum}
  \item{ymax}{data$y maximum}
  \item{yeff}{Effective irradiance as numeric value}
  \item{ymean}{Mean unweighted spectral irradiance for range of wavabnd}
  \item{yint}{Waveband unweighted irradiance for range of wavabnd}
  \item{y}{Scaled mean value as numeric, or \code{y.position} if not \code{NULL}}
  \item{wb.name}{character}
  \item{wb.color}{character}
}
}
\examples{
library(photobiology)
library(ggplot2)
# ggplot() methods for spectral objects set a default mapping for x and y.
ggplot(sun.spct, unit.out = "photon") + geom_line() +
  stat_wb_irrad(unit.in = "photon", time.unit = "second")

}
\seealso{
Other stats functions: \code{\link{stat_color}},
  \code{\link{stat_peaks}},
  \code{\link{stat_wb_contribution}},
  \code{\link{stat_wb_mean}},
  \code{\link{stat_wb_relative}},
  \code{\link{stat_wb_sirrad}},
  \code{\link{stat_wb_total}}, \code{\link{stat_wl_strip}},
  \code{\link{stat_wl_summary}}
}

