% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-raw-spct.R
\name{raw_plot}
\alias{raw_plot}
\title{Plot method for spectra expressed as raw detector counts.}
\usage{
raw_plot(spct, w.band, range, pc.out, label.qty, span, annotations, norm,
  text.size, na.rm, ...)
}
\arguments{
\item{spct}{a raw_spct object}

\item{w.band}{list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one}

\item{label.qty}{character string giving the type of summary quantity to use
for labels}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{annotations}{a character vector}

\item{norm}{numeric normalization wavelength (nm) or character string "max"
for normalization at the wavelength of highest peak.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{na.rm}{logical.}

\item{...}{other arguments}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a
raw_spct object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot objects, and can be further manipulated.
  When spct has more than one column with spectral data, each of these
  columns is normalized individually.
}
\keyword{internal}

