% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-calibration-spct.R
\name{cal_plot}
\alias{cal_plot}
\title{Create a complete ggplot for an irradiation calibration spectrum.}
\usage{
cal_plot(
  spct,
  w.band,
  range,
  pc.out,
  label.qty,
  span,
  wls.target,
  annotations,
  geom,
  norm,
  text.size,
  idfactor,
  facets,
  ylim,
  na.rm,
  ...
)
}
\arguments{
\item{spct}{a calibration_spct object}

\item{w.band}{list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one}

\item{label.qty}{character string giving the type of summary quantity to use
for labels, one of "mean", "total", "contribution", and "relative".}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{wls.target}{numeric vector indicating the spectral quantity values for
which wavelengths are to be searched and interpolated if need. The
\code{character} strings "half.maximum" and "half.range" are also accepted
as arguments. A list with \code{numeric} and/or \code{character} values is
also accepted.}

\item{annotations}{a character vector}

\item{geom}{character The name of a ggplot geometry, currently only
\code{"area"}, \code{"spct"} and \code{"line"}. The default \code{NULL}
selects between them based on \code{stacked}.}

\item{norm}{numeric Normalization wavelength (nm) or character string "max",
or "min" for normalization at the corresponding wavelength, "update" to
update the normalization after modifying units of expression, quantity
or range but respecting the previously used criterion, or "skip" to force
return of \code{object} unchanged. Always skipped for
\code{plot.qty == "all"}, which is the default.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{idfactor}{character Name of an index column in data holding a
\code{factor} with each spectrum in a long-form multispectrum object
corresponding to a distinct spectrum. If \code{idfactor=NULL} the name of
the factor is retrieved from metadata or if no metadata found, the
default "spct.idx" is tried. If \code{idfactor=NA} no aesthetic is mapped
to the spectra and the user needs to use 'ggplot2' functions to manually
map an aesthetic or use facets for the spectra.}

\item{facets}{logical or integer Indicating if facets are to be created for
the levels of \code{idfactor} when \code{spct} contain multiple spectra in
long form.}

\item{ylim}{numeric y axis limits,}

\item{na.rm}{logical.}

\item{...}{currently ignored.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a
calibration_spct object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot object, and can be further manipulated.
  When \code{spct} has more than one column with spectral data, each of these
  columns is normalized individually.
}
\keyword{internal}
