% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-filter-spct.r
\name{Afr_plot}
\alias{Afr_plot}
\title{Create a complete ggplot for a filter spectrum.}
\usage{
Afr_plot(
  spct,
  w.band,
  range,
  pc.out,
  label.qty,
  span,
  annotations,
  text.size,
  idfactor,
  ylim,
  na.rm,
  ...
)
}
\arguments{
\item{spct}{a filter_spct object.}

\item{w.band}{list of waveband objects.}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm).}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one.}

\item{label.qty}{character string giving the type of summary quantity to use
for labels.}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{annotations}{a character vector.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{idfactor}{character Name of an index column in data holding a
\code{factor} with each spectrum in a long-form multispectrum object
corresponding to a distinct spectrum. If \code{idfactor=NULL} the name of
the factor is retrieved from metadata or if no metadata found, the
default "spct.idx" is tried. If \code{idfactor=NA} no aesthetic is mapped
to the spectra and the user needs to use 'ggplot2' functions to manually
map an aesthetic or use facets for the spectra.}

\item{ylim}{numeric y axis limits,}

\item{na.rm}{logical.}

\item{...}{currently ignored.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a filter_spct
object showing absorptance.
}
\keyword{internal}
